; $ HT	QT(IU)		AF(F)		P(EZ)
; $ AT	QT(U)		AF(K)		P(E)
; $ AE	V(-)		H(-)		R(89-91)

(defun load-modules ()
   (load "mod-endinit-uz_auf_stzKopf_ortho")
   (load "mod-lochbild")
)

(defun init-connection ()

    (setq LB_DEBUG 0)
		
    (print "*clear*")		
    
    (setq rWinkel (Connect.get CastaData v-atrgewnkl_flansch ))
    (if (= rWinkel 90.0) (progn  (reset-Ende)
				 (init-traegerenden)
    	)
    	(progn	; else
	 			 (calc-TrgEnde-UZ-rotiert)
	)
    )
    
    
(if (= 1 1)	(progn
    (Connect.showAttributes CastaData)
    
    (if (= (connect.get CastaData LinkesEnde) 1) (progn
        (setq TrgEnde (Traeger.get Tr_ID links))
    ))
    (if (= (connect.get CastaData RechtesEnde) 1) (progn
        (setq TrgEnde (Traeger.get Tr_ID rechts))
    ))

    (setq blKpl (blech.create))
    (setq kplLochbild (Lochbild.create))
    (Connect.storeAnschlObjs CastaData blKpl kplLochbild)
    
    (calcAndSetBlechdaten blKpl TrgEnde)
    
    (if (= (connect.get CastaData LinkesEnde) 1) (progn
			(traeger.addabtl Tr_ID blKpl 0.0 0.0 _kopfplattelinks_)
			(calcAndSetLochbildDaten kplLochbild TrgEnde blKpl)
			(traeger.addabtl Tr_ID kplLochbild 0.0 0.0 _kpllochbildlinks_)
    ))
    (if (= (connect.get CastaData RechtesEnde) 1) (progn
			(traeger.addabtl Tr_ID blKpl 0.0 0.0 _kopfplatterechts_)
			(calcAndSetLochbildDaten kplLochbild TrgEnde blKpl)
			(traeger.addabtl Tr_ID kplLochbild 0.0 0.0 _kpllochbildrechts_)
    ))

		(createLochbild kplLochbild blKpl)

    (if (= (connect.get CastaData LinkesEnde) 1) (progn
        (if (= (connect.get CastaData amHtOberflansch) 1) (progn
;            (print "Setze Seitenrichtung")
            (setq abtlFlLochb (Traeger.get Htrg ABTeil kplLochbild))
            (if abtlFlLochb  (Anbauteil.set  abtlFlLochb (SeitRicht -1)))
        ))
    ))		
    (if (= (connect.get CastaData RechtesEnde) 1) (progn
        (if (= (connect.get CastaData amHtUnterflansch) 1) (progn
;            (print "Setze Seitenrichtung")
            (setq abtlFlLochb (Traeger.get Htrg ABTeil kplLochbild))
            (if abtlFlLochb  (Anbauteil.set  abtlFlLochb (SeitRicht -1)))
        ))
    ))		
    
  
    
    (if (= 1 1) (progn
       ;; (Lochbild.set kplLochbild (LB_Art 2))
       (setq abtlFlLochb_HT (Traeger.get Htrg  ABTeil kplLochbild))
       (setq abtlFlLochb_AT (Traeger.get Tr_ID ABTeil kplLochbild))
    
       (setq delta_V_Lchb_AT (Anbauteil.get abtlFlLochb_AT delta_V))
       (korrigiere_Lchb_DeltaV)
    
       (Anbauteil.set abtlFlLochb_HT (Master 1))
       (Anbauteil.set abtlFlLochb_AT (Master 0))
    ))
    (if (= 1 2) (progn
;       (Lochbild.set kplLochbild (LB_Art 2))
	(Lochbild.set kplLochbild (e "0 20 80"))
    
        (setq abtlFlLochb_HT (Traeger.get Htrg  ABTeil kplLochbild))
        (setq abtlFlLochb_AT (Traeger.get Tr_ID ABTeil kplLochbild))
    
    	(setq delta_V_Lchb_AT (Anbauteil.get abtlFlLochb_AT delta_V))
    	(setq delta_V_Lchb_HT (Anbauteil.get abtlFlLochb_HT delta_V))
    	
    ))
    
    ; ******************************************
    ; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
    ; ******************************************
    (setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
    (print anzAnschl)
	  
    (if (/= anzAnschl 0) (progn
	  (alertBox "An dem Knoten ist bereits ein Anschluss vorhanden. Fgen Sie ggf. Anbauteile manuell ein oder nderen Sie die Reihenfolge der Anschlsse."    "ERR_OrderOfConnections")
	)
	(progn
		(createSteifen dp)
    ))


    ; Anpassung an U-Profil-Sttze
    ; bis hierher gleich mit allgemeiner Auflagerung auf Sttzenkopf
    (Anpassung_UProfil)

  
 	; CALLBACK
 	(Blech.set blKpl (formFkt "cb_KplBlech"))
 	(Anbauteil.set HT_ABTeil (formFkt "cb_HT_ABTeil"))
	(print "nach Callbacks")
)) ; - if Ausklammerung ...
)


; ----------------------------------------------------------------------------------------
; CALLBACK-FUNKTIONEN
; ----------------------------------------------------------------------------------------
(defun cb_KplBlech (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       (setq altesDxS		(Lochbild.get kplLochbild dxsKopf))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff))
	       														(DxSKopf (+ altesDxS dpDiff))
	       )
				 
				 (cbDeltaLR kplLochbild dpDiff)
	    ))
	))
)


(defun cb_HT_ABTeil (zp)
	(print "in Callback-Funktion cb_HT_ABTeil")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq xPos_alt (Anbauteil.get HT_ABTeil xPos))
			
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq xPos_neu (Anbauteil.get HT_ABTeil xPos))
	    
	    (print xPos_alt) (print xPos_neu)
	    
	    (if (/= xPos_alt xPos_neu) (progn
	       (setq xPosDiff (- xPos_neu xPos_alt))
	       ;(setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       ;(setq altesDxS		(Lochbild.get kplLochbild dxsKopf))
	       
	       ;(Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff))
	       ;														(DxSKopf (+ altesDxS dpDiff))
	       ;)
	    ))
	))
)



; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB DP_DIFF)
	;(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl (Traeger.get Htrg Abteil KPL_LB))
				 
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_flansch_at (Connect.get CastaData h-atrgewnkl_flansch))
	(print h_wnkl_flansch_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_flansch_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ (* 1.0 DP_DIFF) tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	
	(print "<------------------------------------------------------------------------------")
)


; ====================================================================== 
; ====================================================================== 
; ----------------------------------------------------------------------
(defun calcAndSetBlechdaten (blKopfplatte TrgEnde)

  (print "----------------------------- In calcAndSetBlechdaten")

  (setq hProf (Traeger.get Tr_ID h)
  			t_at	(Traeger.get Tr_ID t)
  			b_at	(Traeger.get Tr_ID b)
	)
	
	(setq t_ht	(Traeger.get Htrg t))
	
	(setq hscherl_at	(TrEnde.get TrgEnde hscherl))
	
	(setq hp hProf)		; erstmal so voreinstellen
  (setq bp 120)
  (setq dOK  5)

	; Blechdicke
	; ----------------------------------------------
	(setq t_at_rund (runde t_at auf 10))
	(setq dp t_at_rund)
	
	; Schraubenbezeichnung aus min. Blechdicke ("mod-lochbild")
	(if (< dp t_ht)
		(setq min_bl dp)
		(setq min_bl t_ht)
	)
	(calcSchraube min_bl) 	; -> S_Bez
	(print s_bez)
	; Schraubenbezeichnung den Lochbildern zuweisen
	(Lochbild.set kplLochbild (S_Bez S_Bez))
	
	
	
  (setq EWinkel (TrEnde.get TrgEnde V_Winkel))
  (print EWinkel)
	(setq sinW (sin (* PI (/ EWinkel 180.0))))
	(if (/= sinW 0) (setq hp (/ hp sinW)))

  (setq hp (- hp dOK 5))	; wir erzeugen eine bndige Kopfplatte
	      
	; Kopfplattenbreite
	; --------------------------
	(setq bp hscherl_at)
	
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Blech.set blKopfplatte (dp dp) 
				(hp hp) 
				(bp bp) 
				(dOK dOK)
	)

  (setq htDeltaV (Traeger.get hTrg delta_V))

  (setq delta_L dp)
  (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
  (print delta_L)
    
  (TrEnde.pTrim TrgEnde dp)

	
)
; ====================================================================== */
(defun createSteifen (dp)
	(print ">-------------------------------------------------------------------------------")
	(print "ERZEUGE STEIFE IM UZ")
	(setq h_at    		(Traeger.get  Tr_Id h)
	      s_at    		(Traeger.get  Tr_Id s)
	      delta_lr_at	(Traeger.get  Tr_Id delta_lr)
	      hStz    		(Traeger.get  HTrg  h)
	      VWnkl   		(connect.get CastaData hpttrg_vwinkel)
	)
	
	;; ...................................  Orientierung ermitteln
	(setq UZ_HWinkel   (connect.get CastaData HptTrg_HWinkel)
	      Stz_RotaWnkl (Traeger.get Tr_ID  R_Winkel)
	      Stz_RotaWnkl (- 360.0 Stz_RotaWnkl)
	      Stz_RotaWnkl (- Stz_RotaWnkl 90.0)
	)
	(if (< Stz_RotaWnkl 0.0) (setq Stz_RotaWnkl (+ Stz_RotaWnkl 360.0)))
        (setq diffWinkel (- UZ_HWinkel Stz_RotaWnkl))
        (print diffWinkel)
        (if (= diffWinkel -270.0) (setq delta_lr_at (- delta_lr_at)))
        (if (= diffWinkel  270.0) (setq delta_lr_at (- delta_lr_at)))
        (if (= diffWinkel   90.0) (setq delta_lr_at (- delta_lr_at)))
	;; ...................................  Orientierung bercksichtigt

	
	(setq cosAlfa (cos (/ (* PI VWnkl) 180.0)))
	(setq tanAlfa (tan (/ (* PI VWnkl) 180.0)))
	
	(print cosAlfa)
	(if (/= cosAlfa 0.0) 
		(setq delta_lr_at (/ delta_lr_at cosAlfa))
	)
	(print delta_lr_at)
	
	
  (setq xPos_ht (connect.get CastaData xPos_HT))
  
	; delta_lr Verschiebung AT
	(if (= (Connect.get CastaData satr-lhtr)  1)
		(setq xPos_ht (+ xPos_ht delta_lr_at))
	)
	(if (= (Connect.get CastaData satr-lhtr) -1)
		(setq xPos_ht (- xPos_ht delta_lr_at))
	)
  
	; Anteil delta_v des UZ
	(setq delta_v_ht (Traeger.get Htrg delta_v))
	
	(setq anteil_delta_v_uz (* delta_v_ht tanAlfa))
	(print anteil_delta_v_uz)
	(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_ht (- xPos_ht anteil_delta_v_uz)))
	(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_ht (- xPos_ht anteil_delta_v_uz)))
	
	
	
	(setq xPos_H  (* (tan (/ (* VWnkl PI) 180.0)) (* 0.5 hStz)))
	(setq xPos_dp (* (tan (/ (* VWnkl PI) 180.0)) dp))



	(setq blSteifeOben (blech.create))
	(Connect.storeAnschlObjs CastaData blSteifeOben)
	(traeger.addabtl Htrg blSteifeOben 0.0 0.0 _vollsteife_beids_) ;1539
	
	(setq AbtlSteife_1 (traeger.get Htrg ABTeil blSteifeOben))
	(Anbauteil.set  AbtlSteife_1 (xpos xPos_ht))

	
	(if (/= VWnkl 0.0) 
		(progn
	    (print "*** Anbauteil setze Winkel: ") (print VWnkl)
	    (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	        (print "****** amHtUnterFlansch ") (print VWnkl)
	        (if (> VWnkl 180.0)	
						(Anbauteil.set  AbtlSteife_1 (Winkel (- 360.0 VWnkl)))
						(Anbauteil.set  AbtlSteife_1 (Winkel (- VWnkl)))
					)
	        
	    ))
	    (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	        (print "****** amHtOberFlansch ") (print VWnkl)
	        (Anbauteil.set  AbtlSteife_1 (Winkel (- VWnkl)))
	    ))
	    (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
	        (print "****** anHtRechtesEnde ") (print VWnkl)
;	        (setq xPosOben  (- xPosOben  xPos_H))			;; Korrektur Sept 2009 - berflssige Zeile u. Variable
		(Anbauteil.set  AbtlSteife_1 (xpos xPos_ht))
	    ))
		)
	)


	(Traeger.updvollstf Htrg)
	(print "<-------------------------------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild
; ----------------------------------------------------------------------------------------
(defun createLochbild (Lchb_ID BlechID)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE FLANSCHLOCHBILD")
	(setq xPos_ht 		(Connect.get CastaData xPos_ht)
				vwinkel_ht	(Connect.get CastaData hpttrg_vwinkel)
	)
	
	(setq h_ht				(Traeger.get Htrg h)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq h_at				(Traeger.get Tr_ID h))
	
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq e0 (Lochbild.get Lchb_ID e0)
				e1 (Lochbild.get Lchb_ID e1)
	)
	
	(setq tanW (tan (/ (* PI vwinkel_ht) 180.0)))
	(setq cosW (cos (/ (* PI vwinkel_ht) 180.0)))
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq Flansch _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq Flansch _flanschlochbild_uf_)
	)
	
	; Verschiebung aus Neigung HT
	(setq dp_kpl	(Blech.get BlechID dp))
	(setq h_ht_halb (* 0.5 h_ht))
	
	(setq xPos_ht (- xPos_ht (* (+ h_ht_halb dp_kpl) tanW)))
	
	; delta_lr Verschiebung AT
	(setq anteil_delta_lr_ht (/ (* 1.0 delta_lr_at) cosW))
	(if (= (Connect.get CastaData satr-lhtr)  1)
		(setq xPos_ht (+ xPos_ht anteil_delta_lr_ht))
	)
	(if (= (Connect.get CastaData satr-lhtr) -1)
		(setq xPos_ht (- xPos_ht anteil_delta_lr_ht))
	)
	
	(print xPos_ht)
	; delta_v Verschiebung HT
	(setq anteil_delta_v_ht (* delta_v_ht tanW))
	;(print anteil_delta_v_ht)
	(setq xPos_ht (- xpos_ht anteil_delta_v_ht))
	(print xPos_ht)
	
	
		
	; Anbauteilwinkel HT
	(if (= (Connect.get CastaData vatr-shtr)  1)	(setq winkel_abtl_ht 270.0))
	(if (= (Connect.get CastaData vatr-shtr) -1)	(setq winkel_abtl_ht  90.0))	
		
	(Traeger.addabtl Htrg Lchb_ID xPos_ht winkel_abtl_ht Flansch)
	
	(setq delta_v_abtl_ht (- (* 0.5 h_at)))
	
	
	
	; ------------------------------------------------------------------
	; Anbauteil AT
	; ------------------------------------------------------------------
	(setq delta_v_abtl_at 0.0)
	
	(print delta_v_at)
	; Anteil delta_v AT
	(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at delta_v_at)))
	(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at delta_v_at)))
	
	;Anteil der delta_lr Verschiebung des HT (Riegel) an delta_v Verschiebung Anbauteil_LB AT (Sttze)
	(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at delta_lr_ht)))
	(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at delta_lr_ht)))
	
	(print "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ HIER ...")
	(print delta_v_abtl_at)

	; Korrektur AF - Juli 2009 -----------------------
	(setq delta_lr_abtl_ht 0.0)
	(berechneH_NeigungsAnteil)
	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
	   (if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht)))
	))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
	   (if (= (Connect.get CastaData linkesEnde) 1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht)))
	))
	; Korrektur AF - Juli 2009 -(Ende)-----------------

	(if (= (Connect.get CastaData amHtUnterflansch) 1) 	(setq delta_lr_abtl_ht 0))	; Korrektur AF - Sept 2009 - Wert ist nicht erforderlich

	
	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	(Anbauteil.set HT_ABTeil 	(Master    	1)
					(delta_v 	delta_v_abtl_ht)
					(delta_lr	delta_lr_abtl_ht)
	)
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))
	(Anbauteil.set AT_ABTeil 	(winkel  0.0)
					(Master      0)
					(delta_v delta_v_abtl_at)
	)
	
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1) (progn
		(setq dummy (Lochbild.create))
		(Lochbild.copy dummy Lchb_ID)
						
		(if (= (connect.get CastaData LinkesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
		)
		(if (= (connect.get CastaData RechtesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
		)
			
		(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
		(Anbauteil.set dummy_abtl 	(Master 1)	
						(delta_v delta_v_abtl_at)
		)
	))
	;===================================================================
	
	(print "<-----------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde BlechID)
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID 
		(Guete   "4.6")
		(e       "60 0 0 0 0 0")
		(w       "80  0")
	)
	
	(setq h_trg (Traeger.get Tr_ID h)
				s_trg (Traeger.get Tr_ID s)
				b_trg	(Traeger.get Tr_ID b)
				r_trg (Traeger.get Tr_ID r)
	)
	
	(setq t_htrg 			(Traeger.get Htrg t)
				s_htrg			(Traeger.get Htrg s)
				r_htrg			(Traeger.get Htrg r)
				b_ht				(Traeger.get Htrg b) 
				delta_l_ht	(Traeger.get Htrg delta_l)
	)
	
	(setq h_trg_halb	(* h_trg 0.5))
	
	(setq akt_hp 		(Blech.get BlechID hp)
				akt_dok		(Blech.get BlechID dok)
				dp_blech	(Blech.get BlechID dp)
	)
	
	(if (< dp_blech t_htrg)
		(setq min_blech dp_blech)
		(setq min_blech t_htrg)
	)
	(print min_blech)
	; Schraubengre ermitteln und setzen
	(calcSchraube min_blech)
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
	(print S_Bez)
	 
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq min_hp (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
		
	(print akt_dok)
	
	
	(if (< akt_hp b_ht)
		(progn
			(setq e0 (* akt_hp 0.25))		
			(setq e1 (* akt_hp 0.5))
		)
		(progn
			(setq diff (- h_trg b_ht))
			(setq diff_halb (* 0.5 diff))
			
			(setq ant_at (* 0.25 (- b_ht s_htrg (* 2.0 r_htrg))))
			
			(setq e0 (+ diff_halb ant_at))
			(setq e1 (+ s_htrg (* 2.0 r_htrg) (* 2.0 ant_at)))
		)
	)

	(setq e0rund (runde e0 auf 5))					
	(setq e1rund (runde e1 auf 5))
			
	(Lochbild.set Lchb_ID (e0 e0)
												(e1 e1)
												;(e2 200)
	)
	
	(if (= LB_DEBUG 1)
			(Lochbild.set Lchb_ID (e2 400))
	)
	
	; w0
	; --------------------------
	(setq w0 (+ (* 0.5 b_trg) r_trg (* 0.5 s_trg)))
	;(setq w0 (+ s_htrg (* 0.5 r_htrg) e1_blech_rund))
	(setq w0 (runde w0 auf 5))
	
	;(Lochbild.set Lchb_ID (w0 e1_blech_rund))
	(Lochbild.set Lchb_ID (w0 w0))
	
	(Lochbild.set Lchb_ID (klemml 	(+ t_htrg dp_blech))
			      						(dxSKopf  dp_blech)
			      						
			      						
	)
		
	;(Blech.set BlechID (bp (+ (* 2 e_blech_rund) w0)))
	
	(print "ENDE LOCHBILDDATEN")
	(print "------------------------------------------------------------")
)

(defun berechneH_NeigungsAnteil ()	
	(print "NEIGUNG HORIZONTAL")
	; Anteil AT-Neigung (horiz.)
	(setq 	h_ht 		(Traeger.get Htrg h)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	; --- hier muss etwas getrixt werden, weil David die X-Ps am Unterflansch
	; angesetzt hat. Nur wei ich nicht, wieviel sich dann andernorts noch ndert,
	; wenn ich die x-Pos auf die Achse des HT beziehen wrde.
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq h_ht_halb (* 1.0 h_ht))
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq h_ht_halb 0.0)
	)


	
	(setq kpl_dp 			(Blech.get blKpl dp))
	(setq kpl_dp (* 2.0 kpl_dp))
;	(setq kpl_dp 0.0)
	
	(setq anteil_stz (+ (* 1.0 delta_v_ht) (+ h_ht_halb kpl_dp)))
	(setq anteil_stz (+ (* 1.0 delta_v_ht) h_ht_halb))
	(setq anteil_stz (+ h_ht_halb kpl_dp))
	(print anteil_stz)
	
	(setq at_rwinkel (Connect.get CastaData h-atrgewnkl_flansch))
	(setq at_rwinkel (- at_rwinkel 90.0))
	(print at_rwinkel)
	
	(setq tanRW (tan (/ (* PI at_rwinkel) 180.0)))
	(print tanRW)
	
	(setq anteil_hneigung (* anteil_stz tanRW))
	(print anteil_hneigung)
	
	(if (= (Connect.get CastaData rechtesEnde)  1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
			(if (= (Connect.get CastaData satr-shtr)  0)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
		)
	)
	(if (= (Connect.get CastaData linkesEnde)  1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
			(if (= (Connect.get CastaData satr-shtr)  0)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
		)
	)
)
(defun reset-Ende ()
    (if (= (Connect.get CastaData rechtesEnde)  1) (setq trgEnde (Traeger.get Tr_ID rechts)))
    (if (= (Connect.get CastaData linkesEnde)  1)  (setq trgEnde (Traeger.get Tr_ID links)))
    (TrEnde.set trgEnde (V_Winkel 90.0) (delta_L 0.0))
)

(defun calc-TrgEnde-UZ-rotiert ()

    (print "calc-TrgEnde-UZ-rotiert")

    (if (= (Connect.get CastaData rechtesEnde)  1) (progn
	(setq trgEnde (Traeger.get Tr_ID rechts))
    ))
    (if (= (Connect.get CastaData linkesEnde)  1) (progn
	(setq trgEnde (Traeger.get Tr_ID links))
    ))

   ; Winkel berechnung
   (setq rWinkel (Connect.get CastaData v-atrgewnkl_flansch ))
   (setq sinAlfa (sin (/ (* PI rWinkel) 180.0)))
   (setq tanAlfa (tan (/ (* PI rWinkel) 180.0)))

   
   ; AT ist die Sttze
   ; HT ist der Unterzug
   (setq h_HT 	(Traeger.get Htrg  h)
   	 dv_HT	(Traeger.get Htrg  delta_V)
   	 dv_AT	(Traeger.get Tr_ID delta_V)
   )
   (setq vVersatz_HT (* 0.5 h_HT))
   (setq vVersatz_HT (+ vVersatz_HT dv_HT))
   
   (setq vVersatz_AT (/ dv_AT tanAlfa))
   (if (= (Connect.get CastaData linkesEnde)  1) (setq vVersatz_AT (- vVersatz_AT)))
   
   (setq trgKuerzen (/ vVersatz_HT sinAlfa))
   (setq trgKuerzen (+ trgKuerzen  vVersatz_AT))

   (TrEnde.set trgEnde (V_Winkel rWinkel) (delta_L trgKuerzen))
 

)

(defun korrigiere_Lchb_DeltaV () 
   (if (= (Connect.get CastaData rechtesEnde)  1) (progn
	(setq trgEnde (Traeger.get Tr_ID rechts))
    ))
    (if (= (Connect.get CastaData linkesEnde)  1) (progn
	(setq trgEnde (Traeger.get Tr_ID links))
    ))
    (setq EWnkl (TrEnde.get trgEnde V_Winkel))
    (setq EWnkl (- 90.0 EWnkl))
   (setq h_HT 	(Traeger.get Htrg  h)
   	 dv_HT	(Traeger.get Htrg  delta_V)
   	 dlr_HT	(Traeger.get Htrg  delta_LR)
   	 dv_AT	(Traeger.get Tr_ID delta_V)
   )

    (setq sinAlfa (sin (/ (* PI EWnkl) 180.0)))
    (setq cosAlfa (cos (/ (* PI EWnkl) 180.0)))
    (setq tanAlfa (tan (/ (* PI EWnkl) 180.0)))
    

    (setq abtlFlLochb_HT (Traeger.get HTrg ABTeil kplLochbild))
    (setq VScherHoehe (TrEnde.get trgEnde VScherL))
    (Anbauteil.set abtlFlLochb_HT (delta_V (* -0.5 VScherHoehe)))
    
 
    (setq abtlFlLochb_AT (Traeger.get Tr_ID ABTeil kplLochbild))
    (setq delta_V_Lchb_AT (Anbauteil.get abtlFlLochb_AT delta_V))
    
    (setq dlv_Val (* 0.5 h_HT))
    (setq dlv_Val (+ dlv_Val dv_HT))
    
    (setq dlv_Val (TrEnde.get trgEnde delta_L))
    (setq dp (Blech.get blKpl dp))
    (setq dlv_Val (- dlv_Val dp))

    ; Rotation des HT alleine
    (setq dlv_Neu (* dlv_Val sinAlfa))
    (if (= (Connect.get CastaData linkesEnde)  1) (setq dlv_Neu (- dlv_Neu)))
    
    ; seitliche Verschiebung des HT (horizontalem Profil)
    (if (= (Connect.get CastaData vatr-shtr)  1) (setq dlv_Neu (- dlv_Neu dlr_HT)))
    (if (= (Connect.get CastaData vatr-shtr) -1) (setq dlv_Neu (+ dlv_Neu dlr_HT)))
    
    
    (setq dlv_Neu (+ dlv_Neu (* dv_AT cosAlfa)))
    
    
    (Anbauteil.set abtlFlLochb_AT (delta_V (- dlv_Neu)))


)

(defun Anpassung_UProfil ()
   ; Falluntersuchung - liegt die ffnung des U-Profils auch in
   ; Richtung des Trgerprofils oder ist sie nach auen gerichtet
   
   (setq AsymmetrieFall 0)
   (if (= (Connect.get CastaData anHtLinkesEnde )  1) (progn
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq AsymmetrieFall 1))
   ))
   (if (= (Connect.get CastaData anHtRechtesEnde )  1) (progn
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq AsymmetrieFall 1))
   ))

   ; Variablen, die fr beide Flle zum Einsatz kommen
   (if (= (Connect.get CastaData anHtRechtesEnde )  1) (progn
	(setq trgEnde (Traeger.get HTrg rechts))
    ))
    (if (= (Connect.get CastaData anHtLinkesEnde )  1) (progn
	(setq trgEnde (Traeger.get HTrg links))
    ))

    (setq bProf		(Traeger.get Tr_ID b)
    	  bProf2	(* 0.5 bProf)
    )
    ; ---------------------------------------------------------------
   

    (if (= AsymmetrieFall 1) (progn
	    (setq delta_L_curr (TrEnde.get trgEnde delta_L))
	    (setq delta_L_new (+ delta_L_curr bProf2))
	    (TrEnde.set trgEnde (delta_L delta_L_new))
	    
	    (setq bpNew (* 2.0 bProf)
	    	  bpNew (runde bpNew auf 10)
	    )
	    (Blech.set blKpl (bp bpNew) (xAsym (* 0.5 bpNew)))
	
	    (Lochbild.set kplLochbild (LB_Art 2) (w0 (* 0.75 bpNew)))	
	
	    (if (objExist blSteifeOben) (progn
		(setq dp (Blech.get blSteifeOben dp))
		(setq abtl_Stf (Traeger.get HTrg ABTeil blSteifeOben))
		(setq xPos_Stf (Anbauteil.get abtl_Stf xPos))
		
	
		(if (= (Connect.get CastaData satr-lhtr)  1) (setq xPosNew (+ xPos_Stf (* 0.5 dp))))
		(if (= (Connect.get CastaData satr-lhtr) -1) (setq xPosNew (- xPos_Stf (* 0.5 dp))))
	
	       
	       (Anbauteil.set abtl_Stf (xPos xPosNew))
	       
	       (Blech.set blSteifeOben (delta_lr 20))
	    ))
    ))

    (if (= AsymmetrieFall 0) (progn
	    (setq delta_L_curr (TrEnde.get trgEnde delta_L))
	    (setq delta_L_new (- delta_L_curr bProf2))
	    (TrEnde.set trgEnde (delta_L delta_L_new))
	    
	    (setq ds (Lochbild.get kplLochbild sdurchm))
	    (setq bpMin (* 10 ds))
	    (setq bpNew (runde bpMin auf 10))
	    (Blech.set blKpl (bp bpNew))
	    
	    (setq w0_Min (* 4 ds)
	    	  w0     (runde w0_Min auf 10)
	    )
	    (Lochbild.set kplLochbild  (w0 w0))
	    
    ))

)
