; $ HT		QT(IUK)	AF(F)		P(EZ)
; $ AT		QT(IUK)	AF(K)		P(E)
; $ AE		V(-)			H(-)		R(0-1)

(defun load-modules ()
	(load "mod-endinit-uz_auf_stzKopf")
	
)

(defun init-connection ()

	(print "*clear*")
	
	(init-traegerenden)
	; (setq AnschlussTyp (Connect.get CastaData AnschlussTyp))
	; (print AnschlussTyp)
	
	(setConnection_HK)

	(Lochbild.set lochb (e "0 25 75 100 0 0"))
	
)
(defun setConnection_HK ()
	(setq LB_DEBUG 0)
	
	(setq blKpl (blech.create))
	(setq lochb	(lochbild.create))
	(Connect.storeAnschlObjs CastaData blKpl lochb) 

	(if (= (connect.get CastaData LinkesEnde)  1)	(setq TrgEnde (Traeger.get Tr_ID links)))
	(if (= (connect.get CastaData RechtesEnde) 1) 	(setq TrgEnde (Traeger.get Tr_ID rechts)))
	
	(calcAndSetBlechdaten 	 blKpl	TrgEnde)
	(calcAndSetLochbilddaten lochb	blKpl)
	(createFlanschLochb	 lochb	blKpl)
	
	(move_Plate_and_Bolts)

	(print " ----------------------------- ")
	(setq abtl_lb_ht (Traeger.get Htrg Abteil  lochb))
	(setq abtl_lb_at (Traeger.get Tr_ID Abteil lochb))

	(Anbauteil.set abtl_lb_ht (Master 0))
	(Anbauteil.set abtl_lb_at (Master 1))

	(Lochbild.set lochb
		(S_Bez "M12")	; Hollo-Bolt-Schrauben kleiner
		(Montage  7)	; ID fr Hollo Bolt Schrauben
		(dxSKopf  0)
	)

	; CALLBACKS
	(Blech.set blKpl (formFkt "cb_blKpl"))

	
	; (setq seitricht_AT (Anbauteil.get abtl_lb_at seitricht))
	; (setq seitricht_HT (Anbauteil.get abtl_lb_ht seitricht))
	; Seitenrichtung ist wichtig fr halbe Lochbilder
;	(if (= (Connect.get CastaData rechtesEnde) 1)  	(Anbauteil.set abtl_lb_ht (seitricht -1)))
	(setq lSeitR 1)
	(if (= (Connect.get CastaData sAtr-sHtr) 1) (progn
		(setq lSeitR -1)
		(if (= (Connect.get CastaData rechtesEnde) 1) (setq lSeitR (- lSeitR)))
	))
	(if (= (Connect.get CastaData sAtr-sHtr) -1) (progn
		(setq lSeitR -1)
		(if (= (Connect.get CastaData rechtesEnde) 1) (setq lSeitR (- lSeitR)))
	))
	(Anbauteil.set abtl_lb_ht (seitricht lSeitR))
	
)

(defun calcAndSetBlechdaten (blKopfplatte TrgEnde)
	(print "----------------------------- In calcAndSetBlechdaten")
	
	(setq	hProf 		(Traeger.get Tr_ID h)
		t_at		(Traeger.get Tr_ID t)
		b_at		(Traeger.get Tr_ID b)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)

	(setq	b_ht		(Traeger.get Htrg b)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq t_at_rund (runde t_at auf 10))
	
	(setq hp hProf)		; erstmal so voreinstellen
  	(setq bp 120)
  	(setq dp  t_at_rund)
  	(setq dOK  5)

	(setq scherl_ht (TrEnde.get TrgEnde vscherl))
	(print scherl_ht)
	
	(setq hp scherl_ht)

	(setq hp (- hp (* 2.0 dOK)))	; wir erzeugen eine bndige Kopfplatte
	      
	(setq bp b_ht)
	
	
	; delta_lr
	(setq delta_lr_blech 0.0)
	(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_blech (- delta_lr_ht delta_lr_at)))
	(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_blech (- (- delta_lr_ht) delta_lr_at))) 
	
	; Anteil der horizontalen Neigung an delta_lr
	; ---------------------------------------------
	(setq	h_uz 		(Traeger.get Htrg h)
		r_winkel_uz	(Traeger.get Htrg r_winkel)
	)
	(setq	h_uz_halb	(* 0.5 h_uz))
	
	(setq tanW (tan (/ (* PI r_winkel_uz) 180.0)))
	
	(setq anteil_uz (+ h_uz_halb dp))
	
	(setq anteil_neigung (* anteil_uz tanW))
	
	(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_blech (- delta_lr_blech anteil_neigung)))
	(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_blech (+ delta_lr_blech anteil_neigung)))
	
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Blech.set blKopfplatte 
			(dp 		dp) 
			(hp 		hp) 
			(bp 		bp) 
			(dOK 		dOK)
			(delta_lr	delta_lr_blech)
	)

	(setq htDeltaV (Traeger.get hTrg delta_V))

	(setq delta_L dp)
	(if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
	(print delta_L)
	(TrEnde.pTrim TrgEnde dp)
)

; ------------------------------------------------------------------
; Berechnet die Daten des Lochbildes
; ------------------------------------------------------------------
(defun calcAndSetLochbilddaten (Lchb_ID BlechID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID 
		(Guete   "4.6")
		(e       "60 60 0 0 0 0")
		(w       "80  0")
	)
	
	; allg. Daten holen
	(setq	h_trg	(Traeger.get Tr_ID h)
		s_trg	(Traeger.get Tr_ID s)
		t_trg	(Traeger.get Tr_ID t)
		r_trg	(Traeger.get Tr_ID r)
	)
	
	(setq	t_htrg 	(Traeger.get Htrg t)
		s_htrg	(Traeger.get Htrg s)
		r_htrg	(Traeger.get Htrg r)
		b_htrg	(Traeger.get Htrg b)
	)
	
	(setq	akt_hp 		(Blech.get BlechID hp)
		akt_bp		(Blech.get BlechID bp)
		akt_dok		(Blech.get BlechID dok)
		dp_blech	(Blech.get BlechID dp)
	)
	
	(if (= (Connect.get CastaData LinkesEnde) 1)  (setq AtEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData RechtesEnde) 1) (setq AtEnde (Traeger.get Tr_ID rechts)))
	
	(setq	h_scherl_at	(TrEnde.get AtEnde vscherl)
		v_winkel_at	(TrEnde.get AtEnde v_winkel)
	)
	(print v_winkel_at)
	
	(if (> v_winkel_at 90.0)
		(setq v_winkel_at (- 180 v_winkel_at))
	)
	(print v_winkel_at)
	
	(setq tanV_stz (tan (/ (* PI v_winkel_at) 180.0)))
	(setq sinV_stz (sin (/ (* PI v_winkel_at) 180.0)))
	(print tanV_stz)
	(print sinV_stz)
	
	
	; Schraube anhand der Trgerhhe auswhlen
	(if (< h_trg 300)
		(setq S_Bez "M16")
		(setq S_Bez "M20")
	)
	(Lochbild.set Lchb_ID	(S_Bez 		S_Bez)
				(klemml 	(+ t_htrg dp_blech))
	)
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	; min. Rand- und Lochabstnde (default-Werte)
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	; min. Blechhhe aus Lochbild fr zwei Schraubenlagen
	(setq min_hp (+ e1_blech_rund (* e_blech_rund 2.0))) 
	
	
	(setq anteil_e0_aus_neigung (/ dp_blech tanV_stz))
	(print anteil_e0_aus_neigung)
	
    (if (= 1 1) (progn
	; e0 so berechnen, dass die Schraube eingefhrt werden kann
	; ------------------------------------------------------------------
	(setq schr_l (Lochbild.get Lchb_ID laenge))
	(print schr_l)
	
	(setq min_einbau (/ schr_l tanV_stz))
	(print min_einbau)
	
	(setq anteil_stz_flansch (/ t_trg sinV_stz))
	(print anteil_stz_flansch)
	
	(setq anteil_aus_dschr (runde d_schr auf 10))
	(print anteil_aus_dschr)
	
	(setq e0_fuer_einbau (+ anteil_e0_aus_neigung anteil_stz_flansch min_einbau anteil_aus_dschr))
	(print e0_fuer_einbau)
	
	(setq default_e0 (+ (* h_scherl_at 0.25) anteil_e0_aus_neigung))
	(print default_e0)
	
	(setq e0_gew 0)
	
	; Prfen, welches e0 benutzt werden soll
	(if (>= e0_fuer_einbau default_e0)
		(setq e0_gew e0_fuer_einbau)
		(setq e0_gew default_e0)
	)
	
	(print akt_hp)
	(setq e1_gew (- akt_hp (* 2.0 e0_gew))) 
	(print e1_gew)
    ))
	
	(if (< e1_gew e1_blech_rund)
		(progn
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq e0_gew (+ (* h_scherl_at 0.5) anteil_e0_aus_neigung))
			(setq e1_gew 0)
		)
	)
	
	
	
	
	(print akt_hp)
	; entscheiden, ob eine oder zwei Schraubenlagen eingefgt werden
	(if (> akt_hp min_hp)
		(progn
			(setq e0 e0_gew)
			(setq e0rund (runde e0 ab 5))
			(setq e1 e1_gew)
			(setq e1rund (runde e1 auf 5))
			(print e0)
			(print e0rund)
			(print e1rund)
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 e1rund)
			)
		)
		(progn
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq e0 e0_gew)
			(setq e0rund (runde e0 auf 5))
			
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 0)
			)
		)		
	)
	
	;(Lochbild.set Lchb_ID (e0 1.0))
	
	
	;(setq abst_e_aus_at (+ (* r_htrg 2.0) s_htrg d_schr))
	(setq abst_e_aus_ht (+ (* 0.5 b_htrg) r_htrg (* 0.5 s_htrg)))
	
	(if (>= e1_blech_rund abst_e_aus_ht)
		(setq w0 e1_blech_rund)
		(setq w0 abst_e_aus_ht)
	)
	(setq w0rund (runde w0 auf 5))
	
	(print e1_blech_rund)
	(print dp_blech)
	(Lochbild.set Lchb_ID	
			(w0 		w0rund)
			;(klemml 	(+ t_htrg dp_blech))
			(dxSKopf	dp_blech)
	)
		
	(if (= LB_DEBUG 1)	(Lochbild.set Lchb_ID (e2 400.0)))
		
	(print "<-----------------------------------------------------------")
)

(defun	createFlanschLochb (Lchb_ID Blech_ID)
	(print "------------------------------------------------------------")
	(print "ERZEUGT FLANSCHLOCHBILD")
	(setq 	h_trg 		(Traeger.get Tr_ID h)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		rwinkel_stz	(Traeger.get Tr_ID r_winkel)
	)
	
	(setq 	sysl 		(Traeger.get Htrg syslng)
		h_htrg		(Traeger.get Htrg h)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq dp_blech		(Blech.get Blech_ID dp))
	(print dp_blech)
	
	; Art des Flanschlochbildes
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq flansch _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq flansch _flanschlochbild_uf_)
	)
	
	(if (= (Connect.get CastaData anschlzwhtenden) 0)
		(progn
			; HT-Ende bestimmen
			(if (= (Connect.get CastaData anHtlinkesEnde) 1)
				(setq HtEnde (Traeger.get Htrg links))
			)
			(if (= (Connect.get CastaData anHtrechtesEnde) 1)
				(setq HtEnde (Traeger.get Htrg rechts))
			)
			
			; AT-Ende bestimmen
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq TrgEnde (Traeger.get Tr_ID links))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq TrgEnde (Traeger.get Tr_ID rechts))
			)
			
			; HT-ENDE Daten
			(setq v_scherl_ht (TrEnde.get HtEnde vscherl)
						v_winkel_ht	(TrEnde.get HtEnde v_winkel)
			)
			
			; AT-ENDE Daten
			(setq v_scherl_at (TrEnde.get TrgEnde vscherl) 
						v_winkel_at	(TrEnde.get TrgEnde v_winkel)
			)
		)
	)
	
	

	(calcFlanschLochbild Lchb_ID Blech_ID)
	
	
	(if (= (connect.get CastaData LinkesEnde) 1) (progn
		(print "LINKS")
		(traeger.addabtl Tr_ID blKpl 0.0 0.0 _kopfplattelinks_)
		(traeger.addabtl Tr_ID lochb 0.0 0.0 _kpllochbildlinks_)
	))
	(if (= (connect.get CastaData RechtesEnde) 1) (progn
		(print "RECHTS")
		(traeger.addabtl Tr_ID blKpl 0.0 0.0 _kopfplatterechts_)
		(traeger.addabtl Tr_ID lochb 0.0 0.0 _kpllochbildrechts_)
	))
	
			
	; delta_lr Verschiebung 
	; --------------------------
	(setq delta_lr_abtl_at 0)
	(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at (+ (- delta_lr_ht) delta_lr_at)))	
	(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at (+ delta_lr_ht delta_lr_at)))


	; Verschiebung dem Anbauteil zuweisen
	(setq abtl_lb_at (Traeger.get Tr_ID Abteil lochb))
	(Anbauteil.set abtl_lb_at  (delta_lr delta_lr_abtl_at))

	; Anteil der horizontalen Neigung an delta_lr
	; ---------------------------------------------
	(setq	h_uz 		(Traeger.get Htrg h)
		r_winkel_uz	(Traeger.get Htrg r_winkel)
	)
	(setq h_uz_halb (* 0.5 h_uz))
	
	
	(setq tanW (tan (/ (* PI r_winkel_uz) 180.0)))
	
	(setq anteil_uz (+ h_uz_halb dp))
	
	(setq anteil_neigung (* anteil_uz tanW))
	
	(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at (+ delta_lr_abtl_at anteil_neigung)))
	(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at anteil_neigung)))
	
	
	

	(if (= LB_DEBUG 1)
		(progn
			; TEST
			(setq lbdummy (Lochbild.create))
			(Lochbild.copy lbdummy Lchb_ID)
			
			(if (= (connect.get CastaData LinkesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildlinks_))
			(if (= (connect.get CastaData RechtesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildrechts_))
			
			(setq abtl_lb_at_dummy (Traeger.get Tr_ID Abteil lbdummy))
			(Anbauteil.set abtl_lb_at_dummy (Master 1)
																			(delta_lr delta_lr_abtl_at)
			)
			; TESTENDE
		)
	)
	
	(print "ENDE FLANSCHLOCHBILD")
	(print "------------------------------------------------------------")
)

(defun calcFlanschLochbild (Lchb_ID Blech_ID)
	(setq xPos_HT (Connect.get CastaData xPos_ht))
	(print xPos_HT)
			
	(setq	e0 	(Lochbild.get Lchb_ID e0)
		e1	(Lochbild.get Lchb_ID e1)
	)
	(print e0)
	(print e1)
			


   (if (= 1 1)	(progn			
	; Anteil Neigung HT		
	(setq v_wnkl_ht (Connect.get CastaData hpttrg_vwinkel))
	(print v_wnkl_ht)
					

	(setq v_wnkl_ht (Connect.get CastaData afl_VWinkel))
	(setq v_wnkl_ht (- v_wnkl_ht 90.0))
;	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq v_wnkl_ht (- v_wnkl_ht)))
					
	(setq tanVW	(tan (/ (* PI v_wnkl_ht) 180.0)))
	(print tanVW)

					
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
		(setq anteil_ht_neigung (* (+ (* 0.5 h_htrg) delta_v_ht) tanVW))
;		(setq xPos_HT (- xPos_HT anteil_ht_neigung))
	))
	(if (= (Connect.get CastaData amHtOberflansch) 1)  (progn
		(setq anteil_ht_neigung (* (- (* 0.5 h_htrg) delta_v_ht) tanVW))
;		(setq xPos_HT (+ xPos_HT anteil_ht_neigung))
	))
	(print anteil_ht_neigung)
	(print xPos_HT)		
   ))
			
   (if (= 1 1)	(progn		
	; Anteil Schrge des AT
	(setq vscherl_stz (TrEnde.get TrgEnde vscherl))
	(setq vscherl_stz_halb (* 0.5 vscherl_stz))
			
	; Sept 2009 (AF) neu eingefgt, damit auch Anschlsse am Unterflansch klappen
	(setq VATr-LHTr (Connect.get CastaData vatr-lhtr))
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq xPos_HT (- xPos_HT  vscherl_stz_halb anteil_ht_neigung)))
	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq xPos_HT (- xPos_HT  (- vscherl_stz_halb) anteil_ht_neigung)))

   ))
	

    (if (= 1 1)	(progn		
	; Anteil delta_V AT
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (print "rechtesEnde satr-shtr =  1"))
			(if (= (Connect.get CastaData satr-shtr) -1) (print "rechtesEnde satr-shtr = -1"))
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (print "linkesEnde satr-shtr =  1"))
			(if (= (Connect.get CastaData satr-shtr) -1) (print "linkesEnde satr-shtr = -1"))
		)
	)


	(print delta_v_at)
	(print xPos_HT)

	
	(setq AFlWinkel (Connect.get CastaData AFl_vWinkel))
	(setq cos_aflW (cos (* PI (/ (- AFlWinkel 90.0) 180.0))))
	(setq dvAnteil delta_v_at)
	(if (/= cos_aflW 0.0) (setq dvAnteil (/ dvAnteil cos_aflW)))
	
	(print ".")
	(print delta_v_at)
	(print dvAnteil)
	(print ".")
	
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq xPos_HT (+ xPos_HT dvAnteil)))
	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq xPos_HT (- xPos_HT dvAnteil)))

	(print "nach Einfluss aus dv des AT ...")
	(print xPos_HT)
    ))										

					
	; Winkel Anbauteil
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq abtl_winkel   0.0))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq abtl_winkel   0.0))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq abtl_winkel 180.0))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq abtl_winkel 180.0))
		)
	)		
	(traeger.addabtl Htrg Lchb_ID xPos_HT abtl_winkel flansch)
	

	(setq abtl_lb_HT (Traeger.get HTrg Abteil Lochb))
	(setq dv_AT (Traeger.get Tr_ID delta_V))
	(setq dvAnteil_AT (* 0.0 dv_AT))		; gendert - Faktor 0 eingesetzt -  Apr. 2022
											; dafr muss bei Anschluss von hinten -2 angesetzt werden
	(if (= (Connect.get CastaData at-von-hinten) 1) (setq dvAnteil_AT (* -2.0 dv_AT)))
	; (AlertBox cos_aflW)
	(if (/= cos_aflW 0.0) (setq dvAnteil_AT (/ dvAnteil_AT cos_aflW)))
	
	(Anbauteil.set abtl_lb_HT  (delta_v dvAnteil_AT))

)
; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_blKpl (zp)
	(print "in Callback-Funktion cb_KplBlech")
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get lochb Klemml))
	       (setq dxsKopf_alt	(Lochbild.get lochb dxSKopf))
	       
	       (Lochbild.set lochb 	(Klemml (+ alteKlemml dpDiff)))
	       
	       
	    ))
	))
)
(defun move_Plate_and_Bolts ()

;  )
; (defun Dummy_1 ()
	; Unterscheidung, in welche Richtung das Profil verluft
	(print "*clear*")
	(Connect.showAttributes CastaData)

	(setq sd	(Lochbild.get  Lochb sDurchm))
	(setq hDiff (runde (* 4.0 sd) auf 10))
	
	(setq hp_Kpl (Blech.get blKpl hp))
	(setq hp_Kpl (+ hp_Kpl hDiff))
	
	(setq dOK_kpl (Blech.get blKpl dOK))
	(setq dOK_kpl (- dOK_kpl hDiff))
	
	(if (= (Connect.get CastaData  anHtLinkesende) 1) (progn
		(if (= (Connect.get CastaData vatr-lhtr) -1)		(progn
			(Blech.set  blKpl (hp  hp_Kpl)
									(dOK dOK_kpl)
			)
			(Lochbild.set Lochb (e "0 0 0 0 0 0"))
			(Lochbild.set  Lochb (e0  (* -0.5 hDiff)))
		))
		(if (= (Connect.get CastaData vatr-lhtr)  1)		(progn
			(Blech.set  blKpl (hp  hp_Kpl))
			(Lochbild.set  Lochb (e0 (- hp_Kpl (* 0.5 hDiff))))
		))
	))
	(if (= (Connect.get CastaData  anHtRechtesende) 1) (progn
		(if (= (Connect.get CastaData vatr-lhtr)  1)		(progn
			(Blech.set  blKpl (hp  hp_Kpl)
									(dOK dOK_kpl)
			)
			(Lochbild.set Lochb (e "0 0 0 0 0 0"))
			(Lochbild.set  Lochb (e0  (* -0.5 hDiff)))
		))
		(if (= (Connect.get CastaData vatr-lhtr)  -1)		(progn
			(Blech.set  blKpl (hp  hp_Kpl))
			(Lochbild.set  Lochb (e0 (- hp_Kpl (* 0.5 hDiff))))
		))
	))

	; (Lochbild.set Lochb (e1 30) (e2 70))


)
