; $ G(7)  HT	QT(IU)	 	AF(F)		P(E)
; $ G(7)  AT	QT(IU) 		AF(K)		P(E)
; $ G(7)  AE	V(-)		H(90)		R(0-2 178-180)
; $ 	  HT	QT(IU)		AF(F)		P(E)
; $ 	  AT	QT(IU)		AF(K)		P(E)
; $ 	  AE	V(-)		H(90)		R(-)

(defun load-modules ()
	(load "mod-endinit-uz_auf_stzKopf")
	(load "mod-multiconnect-stz-flansch")
	
	(setq vWinkel_trg 	(Connect.get CastaData trg_vwinkel))
	(print vWinkel_trg)
	
	(if (>= vWinkel_trg 0.0)
		(progn
			(setq at_is_stz 0)
		)
	)
	(if (> vWinkel_trg 75.0)
		(progn
			(setq at_is_stz 1)
		)
	)
	(if (>= vWinkel_trg 105.0)
		(progn
			(setq at_is_stz 0)
		)
	)
	(if (> vWinkel_trg 255.0)
		(progn
			(setq at_is_stz 1)
		)
	)
	(if (> vWinkel_trg 285.0)
		(progn
			(setq at_is_stz 0)
		)
	)
	
	(print at_is_stz)
	
	;AT ist die Sttze
	(if (= at_is_stz 1)
		(progn
			(print "AT IST STTZE")
   		(load "uz_auf_AtstzKopf_Zuglasche")
   	)
  )
  ;HT ist die Sttze
  (if (= at_is_stz 0)
  	(progn
  		(print "HT IST STTZE")
   		(load "uz_auf_HtStzKopf")
   	)
  )
)

(defun init-connection ()

	(print "*clear*")
;       (Connect.showAttributes 	CastaData)
;	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
;		(progn
			(init-traegerenden)
			(calcConnection)
			; korrigiert in 10-2023
			(LochbildAusrichtung)
			; CALLBACKS
			(Blech.set blKpl     (formFkt "cb_blKpl"))
			(Blech.set Zuglasche (formFkt "cb_blZugl"))
;		)
;		(progn
;			(alertBox "An diesem Knoten ist bereits ein Anschluss vorhanden. Der gewhlte Anschluss kann daher nicht eingefgt werden."  "SameNodeConnection_NotPossible")
;		)
;	)


)
; ========================================================================================
(defun LochbildAusrichtung ()

	; HT ist der Riegel - wir betrachten nur diesen Fall hier 
	(setq qs_HT  (Traeger.get HTrg qsForm))
	(setq dlr_HT (Traeger.get HTrg delta_LR))
	(setq bp (Blech.get blKpl bp))

	(if (= qs_HT "U") (progn
		(if (= (Connect.get CastaData sAtr-sHtr)  1) (progn 
			(Lochbild.set lochb (LB_Art  2))
			(setq hVersch_Bl (+ (* 0.5 bp) dlr_HT))
			(Blech.set blKpl (xAsym hVersch_Bl))
		))
		(if (= (Connect.get CastaData sAtr-sHtr) -1) (progn 
			(Lochbild.set lochb (LB_Art -2))
			(setq hVersch_Bl (- (* -0.5 bp) dlr_HT))
			(Blech.set blKpl (xAsym hVersch_Bl))
		))
	))

	(setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil lochb))
	(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil lochb))
	(Anbauteil.set Abtl_Lchb_HT (SeitRicht -1))
)
; ========================================================================================



; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_blKpl (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get lochb Klemml))
	       (setq dxsKopf_alt	(Lochbild.get lochb dxSKopf))
	       
	       (Lochbild.set lochb 	(Klemml (+ alteKlemml dpDiff))
	       											(dxSKopf (+ dxsKopf_alt dpDiff))
	       )
	       
	       
	    ))
	))
)
; ----------------------------------------------------------------------------------------
; Callback fr Zuglasche am AT
; ----------------------------------------------------------------------------------------
(defun cb_blZugl (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get Zuglasche dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get Zuglasche dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
		(setq dpDiff (- dpNeu dpAlt))
		(setq alteKlemml (Lochbild.get LchbZugL Klemml))
		(setq dxsKopf_alt	(Lochbild.get LchbZugL dxSKopf))
	       
		(Lochbild.set LchbZugL 	(Klemml (+ alteKlemml dpDiff))
	       				(dxSKopf dpNeu)
		)

		(if (= (connect.get CastaData anHTLinkesEnde) 1) (progn
		    (setq TrgEnde (Traeger.get HTrg links))
		    (setq dl_vorh (TrEnde.get TrgEnde delta_l))
		    (TrEnde.set TrgEnde (delta_l (- dl_vorh dpDiff)))
		))
		(if (= (connect.get CastaData anHTRechtesEnde) 1) (progn
		    (setq TrgEnde (Traeger.get HTrg rechts))
		    (setq dl_vorh (TrEnde.get TrgEnde delta_l))
		    (TrEnde.set TrgEnde (delta_l (- dl_vorh dpDiff)))
		))
	       
	       
	    ))
	))
)

