; $ G(24)  HT	QT(IU)	 	AF(F)		P(EZ)
; $ G(24)  AT	QT(K) 		AF(K)		P(E)
; $ G(24)  AE	V(-)		H(90)		R(0)
; $ G(30) HT		QT(IUKR)	AF(F)		P(EZ)
; $ G(30) AT		QT(IUKR)	AF(K)		P(E)
; $ G(30) AE		V(90)		H(-)		R(0-1)
; $ 	  HT		QT(IUKR)	AF(F)		P(EZ)
; $ 	  AT		QT(IUKR)	AF(K)		P(E)
; $ 	  AE		V(-)		H(-)		R(0-10 170-180)

(defun load-modules ()
	(load "mod-endinit-uz_auf_stzKopf")
	
	(setq vWinkel_trg 	(Connect.get CastaData trg_vwinkel))
	(print vWinkel_trg)
	
	(if (>= vWinkel_trg 0.0)
		(progn
			(setq at_is_stz 0)
		)
	)
	(if (> vWinkel_trg 75.0)
		(progn
			(setq at_is_stz 1)
		)
	)
	(if (>= vWinkel_trg 105.0)
		(progn
			(setq at_is_stz 0)
		)
	)
	(if (> vWinkel_trg 255.0)
		(progn
			(setq at_is_stz 1)
		)
	)
	(if (> vWinkel_trg 285.0)
		(progn
			(setq at_is_stz 0)
		)
	)
	
	(print at_is_stz)
	
	;AT ist die Sttze
	(if (= at_is_stz 1) (progn
		(print "AT IST STTZE")
   		(load "uz_auf_AtstzKopf")
   		(load "mod-multiconnect-stz-flansch")
   	))

	;HT ist die Sttze
	(if (= at_is_stz 0) (progn
  	    (print "HT IST STTZE")
   	    (load "uz_auf_HtStzKopf")
   	    (load "mod-multiconnect-stz-flansch")
	))
)

(defun init-connection ()

	(print "*clear*")
	(Connect.showAttributes CastaData)

; )
; (defun XXXX ()


	(init-traegerenden)
	
	(calcConnection)
	; korrigiert in 10-2023, 12-2023
	(LochbildAusrichtung)

    	(if (= 1 2) (progn
			(Lochbild.set lochb (LB_Art 2)
				    (e "0 30 80 0 0 0")
					(delta_w 75)
					(w0 0)
			)
    		(setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil lochb))
    		(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil lochb))
    		; (Anbauteil.set Abtl_Lchb_HT (Master 0))
    		; (Anbauteil.set Abtl_Lchb_AT (Master 1))
			
			(setq dlr_AT (Anbauteil.get Abtl_Lchb_AT delta_LR))
			; (AlertBox dlr_AT)
			(setq dlr_HT (Anbauteil.get Abtl_Lchb_HT delta_LR))
			; (AlertBox dlr_HT)
			(setq SeitRicht_HT (Anbauteil.get Abtl_Lchb_HT seitricht))
			; (AlertBox SeitRicht_HT)
    	)) 

	
	; CALLBACKS
	(Blech.set blKpl (formFkt "cb_blKpl"))

)
; ========================================================================================
(defun LochbildAusrichtung ()

	; HT ist der Riegel - wir betrachten nur diesen Fall hier 
	(setq qs_AT  (Traeger.get Tr_ID qsForm))
	(setq qs_HT  (Traeger.get HTrg qsForm))
	(setq dlr_HT (Traeger.get HTrg delta_LR))
	(setq dlr_HT (* 1.0 dlr_HT))
;	(AlertBox dlr_HT)
;	(if (= (Connect.get CastaData amHtOberFlansch) 1) (setq dlr_HT (* -1.0 dlr_HT)))
;	(AlertBox dlr_HT)
	
	(setq bp (Blech.get blKpl bp))

	(if (= qs_AT "U") (progn
	    (setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil lochb))
    	(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil lochb))
		(setq dlr_AT (Anbauteil.get Abtl_Lchb_AT delta_LR))
		(setq dlr_HT (Anbauteil.get Abtl_Lchb_HT delta_LR))
		(setq dlr_HT_neu dlr_AT)
		(setq dlr_AT_neu dlr_HT)
		(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(Anbauteil.set Abtl_Lchb_HT (delta_LR (- dlr_HT_neu)))
			(Anbauteil.set Abtl_Lchb_AT (delta_LR    dlr_AT_neu))
		))
		(if (= (Connect.get CastaData rechtesEnde) 1) (progn
			(Anbauteil.set Abtl_Lchb_HT (delta_LR dlr_HT_neu))
			(Anbauteil.set Abtl_Lchb_AT (delta_LR dlr_AT_neu))
		))

		(setq currLBArt (Lochbild.get lochb LB_Art))
		(Lochbild.set lochb (LB_Art  2))
		(setq w0 (Lochbild.get lochb w0))
		(if (= currLBArt 0) (if (> w0 80) (Lochbild.set lochb (w0 (* 0.5 w0)))))
	))

	(if (= qs_HT "U") (progn
		(if (= (Connect.get CastaData sAtr-sHtr)  1) (progn 
			(Lochbild.set lochb (LB_Art  2))
			(setq hVersch_Bl (- (* 0.5 bp) dlr_HT))
			(setq hVersch_Bl (* 0.5 bp))
			(if (= qs_AT "I") (setq hVersch_Bl 0))
			(Blech.set blKpl (xAsym hVersch_Bl))
		))
		(if (= (Connect.get CastaData sAtr-sHtr) -1) (progn 
			(Lochbild.set lochb (LB_Art -2))
			(if (= qs_AT "U") (Lochbild.set lochb (LB_Art 2)))
			(setq hVersch_Bl (- (* 0.5 bp) dlr_HT))
			(setq hVersch_Bl (* 0.5 bp))
			(if (= qs_AT "I") (setq hVersch_Bl 0))
			(Blech.set blKpl (xAsym hVersch_Bl))
		))
	))
	(if (= qs_HT "I") (progn
		; (AlertBox "hier .... (1)")
	))
	(setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil lochb))
	(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil lochb))

	(if (= (Connect.get CastaData amHtUnterFlansch) 1) (progn
		(if (= (Connect.get CastaData rechtesEnde) 1) (Anbauteil.set Abtl_Lchb_HT (SeitRicht -1)))
	))

	(if (= (Connect.get CastaData amHtOberFlansch) 1) (progn
		(if (= (Connect.get CastaData linkesEnde) 1) (Anbauteil.set Abtl_Lchb_HT (SeitRicht -1)))
		(setq dlr_Abtl (Anbauteil.get Abtl_Lchb_HT delta_LR))
		; (AlertBox dlr_Abtl)
		(setq dlr_Abtl_Neu 0)
		; (setq dlr_Abtl_Neu (- dlr_Abtl))
		(setq dlr_Abtl_Neu dlr_Abtl)
		; (Anbauteil.set Abtl_Lchb_HT (delta_LR dlr_Abtl_Neu))
	))


 (if (= 2 3) (progn
	(if (= (Connect.get CastaData amHtUnterFlansch) 1)
		(if (= (Connect.get CastaData rechtesEnde) 1) (Anbauteil.set Abtl_Lchb_HT (SeitRicht -1)))
	)
	(if (= (Connect.get CastaData amHtOberFlansch) 1) (progn
		(if (= (Connect.get CastaData LinkesEnde) 1) (Anbauteil.set Abtl_Lchb_HT (SeitRicht -1)))
		(setq dlr_AT (Traeger.get Tr_ID delta_LR))
		(setq dlr_Abtl (Anbauteil.get Abtl_Lchb_AT delta_LR))
		; (setq dlr_Abtl_Neu (+ dlr_Abtl dlr_AT))
		(setq dlr_Abtl_Neu (- dlr_Abtl))
		(Anbauteil.set Abtl_Lchb_AT (delta_LR dlr_Abtl_Neu))
		; (AlertBox dlr_Abtl)
		(if (= qs_HT "I") (progn
			(setq Bl_xASym (Blech.get blKpl xAsym))
			(setq Bl_xASym (- Bl_xASym))
			(Blech.set blKpl (xAsym Bl_xASym))
		))
	))
 ))
)
; ========================================================================================



; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_blKpl (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get lochb Klemml))
	       (setq dxsKopf_alt	(Lochbild.get lochb dxSKopf))
	       
	       (Lochbild.set lochb 	(Klemml (+ alteKlemml dpDiff))
	       											(dxSKopf (+ dxsKopf_alt dpDiff))
	       )
	       (AT_Lochbild_dlr_aus_dp dpDiff)
	       ; (AT_Lochbild_dlr_aus_dp dpNeu)
	       
	    ))
	))
)

(defun  AT_Lochbild_dlr_aus_dp (dp)
	(setq rWnkl (Connect.get CastaData r-atrgewnkl_kopf))
	
	
	(if (/= rWnkl 180.0) (progn
		
		(setq dp (* 1.0 dp))
		(setq bl_Wnkl (- 180.0  rWnkl))

		;(if (> rWinkel_UZ 270.0) 
		;		(setq rWinkel_UZ (- 360.0  rWinkel_UZ))
		;		(setq  rWinkel_UZ (- rWinkel_UZ 180.0))
		;)

		(setq tanW (tan (/ (* PI  bl_Wnkl) 180.0)))
		
		(setq dlr_Bl (* tanW dp))
		(print  dlr_Bl)
		(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil lochb))
		
		(setq dlr_Lchb (Anbauteil.get Abtl_Lchb_AT delta_LR))
		(print  dlr_Lchb)
		(setq  dlr_Lchb (+ dlr_Lchb dlr_Bl))
		
		(Anbauteil.set Abtl_Lchb_AT (delta_LR  dlr_Lchb))
	))

)

