; $	HT	QT(IK)		AF(K)		P(E)
; $	AT	QT(IK)		AF(K)		P(E)
; $ AE	V(90)	H(-)		R(-)

; ----------------------------------------------------------------------------------------
;	Einbindung externer Module
; ----------------------------------------------------------------------------------------
(defun load-modules ()
   (load "mod-endinit-uz-uz-gehrung")
   (load "mod-utils")
)


(defun init-connection ()
	
	(Connect.showAttributes CastaData)
	(setq LB_DEBUG 0)
	
	(setConnection)
)


(defun setConnection ()

  (print "in init-connection - (Gehrungs-Sto h)");

	(init-traegerenden)
	
  (if (= (connect.get CastaData linkesEnde) 1)  (print "Linkes Ende"))
  (if (= (connect.get CastaData rechtesEnde) 1) (print "Rechtes Ende"))

  ;(connect.showattributes CastaData)
  
  (setq htkpl 	(Blech.create))
  (setq atkpl 	(Blech.create))
  (setq kpl_lb	(Lochbild.create))
  (Connect.storeAnschlObjs CastaData htkpl atkpl kpl_lb)
  
	(berechneTraegerUnterschiede)
	
  (createKopfplatten htkpl atkpl)
  (korrKopfplatten htkpl atkpl)
  
  (calcLochbildDaten kpl_lb htkpl atkpl)
  (createLochbild kpl_lb)
  
  (korrKplFuerAndereProfile htkpl atkpl)
  
  
  ; CALLBACKS
  (Blech.set htkpl (formFkt "cb_htkpl"))
  (Blech.set atkpl (formFkt "cb_atkpl"))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_htkpl (zp)
	(print "in Callback-Funktion cb_htkpl")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get htkpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get htkpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kpl_lb Klemml))
	       
	       (Lochbild.set kpl_lb 	(Klemml (+ alteKlemml dpDiff)))
				 
				 (cbDeltaLR Htrg kpl_lb dpDiff)
	    ))
	))
)


; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_atkpl (zp)
	(print "*clear*")
	(print "in Callback-Funktion cb_atkpl")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get atkpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get atkpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kpl_lb Klemml))
	       
	       (Lochbild.set kpl_lb 	(Klemml (+ alteKlemml dpDiff))
	       				;(DxSKopf (+ altesDxS dpDiff))
	       )
	       ; Callback-Aufruf
		(cbDeltaLR Tr_ID kpl_lb dpDiff)
	    ))
	))
)


; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (TRG_TYPE KPL_LB DP_DIFF)
	;(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl (Traeger.get Htrg Abteil KPL_LB))
				 
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	(if (= (Connect.get CastaData linkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))
	(setq hwnkl_at_ende (TrEnde.get At_Ende h_winkel))
	(print hwnkl_at_ende)
		
	(setq tanHW (tan (/ (* PI hwnkl_at_ende) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= TRG_TYPE Htrg)
		(progn
			(print "HAUPTTRGER")
			(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr))
		)
	)
	(if (= TRG_TYPE Tr_ID)
		(progn
			(print "ANSCHLUSSTRGER")
			(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr))
		)
	)
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	
	(print "<------------------------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Erzeugt die Kopfplatten
; ----------------------------------------------------------------------------------------
(defun createKopfplatten (BLECH_HT BLECH_AT)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE KOPFPLATTEN")
	
	(setq h_ht	(Traeger.get Htrg h)
				b_ht	(Traeger.get Htrg b)
				t_ht	(Traeger.get Htrg t)
	)
	
	(setq h_at	(Traeger.get Tr_ID h)
				b_at	(Traeger.get Tr_ID b)
				t_at	(Traeger.get Tr_ID t)
	)
	
	(setq hwinkel_at	(TrEnde.get HtEnde h_winkel))
	
	(setq hwinkel_ht	(TrEnde.get AtEnde h_winkel))
	
	(setq xPos_ht (Connect.get CastaData xPos_ht)
				xPos_at	(Connect.get CastaData xPos_at)
	)
	
	; Blechdicke
	(if (>= t_ht t_at)
		(setq dp_kpl t_ht)
		(setq dp_kpl t_at)
	)
	(setq dp_kpl (runde dp_kpl auf 5))
	(print dp_kpl)
	
	; Blechhhe
	(if (>= h_ht h_at)
		(setq hp_kpl h_ht)
		(setq hp_kpl h_at)
	)
	
	; Blechbreite
	(if (>= b_ht b_at)
		(setq bp_kpl b_ht)
		(setq bp_kpl b_at)
	)	
		
	(Blech.set BLECH_HT (dp dp_kpl)
											(hp hp_kpl)
											(bp bp_kpl)
	)
	(Blech.set BLECH_AT (dp dp_kpl)
											(hp hp_kpl)
											(bp bp_kpl)
	)
	
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(Traeger.addabtl Htrg BLECH_HT xPos_ht 0.0 _kopfplatterechts_)
		(Traeger.addabtl Htrg BLECH_HT xPos_ht 0.0 _kopfplattelinks_)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(Traeger.addabtl Tr_ID BLECH_aT xPos_at 0.0 _kopfplatterechts_)
		(Traeger.addabtl Tr_ID BLECH_aT xPos_at 0.0 _kopfplattelinks_)
	)
	
		
	(TrEnde.ptrim HtEnde dp_kpl)
	(TrEnde.ptrim AtEnde dp_kpl)
	
	
	(setq qsform_at (Traeger.get Tr_ID qsform))
	(setq qsform_ht	(Traeger.get Htrg qsform))
	
	(if (= qsform_at "U")
		(progn
			(setq delta_lr_blech (* 0.5 bp_kpl))
			(Blech.set BLECH_AT (delta_lr delta_lr_blech))
		)
	)
	(if (= qsform_ht "U")
		(progn
			(setq delta_lr_blech (* 0.5 bp_kpl))
			(Blech.set BLECH_HT (delta_lr delta_lr_blech))
		)
	)
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Korrigiert die Kopfplatten bei Unterschiedlichen Trgern
; ----------------------------------------------------------------------------------------
(defun korrKopfplatten (BLECH_HT BLECH_AT)
	(print ">-----------------------------------------------------------")
	(print "KORRIGIERE KOPFPLATTEN")
	(setq kplHtrg BLECH_HT)
	(setq kpltrg	BLECH_AT)
	
	(berechneKantenInModus 2)
	
	; neue Kopfplattenhhe
	(setq hp_kpl_ht maxDiff)
	(setq hp_kpl_at maxDiff)
	
	(setq dok_kpl_ht 0)
	(setq dok_kpl_at 0)
	
	(if (< oKante_at oKante_ht)
		(setq dok_kpl_ht (- diff_oben))
		(setq dok_kpl_at (- diff_oben))
	)
	
	(Blech.set BLECH_HT	(dok dok_kpl_ht)
				(hp		hp_kpl_ht)
	)
	(Blech.set BLECH_AT	(dok dok_kpl_at)
				(hp		hp_kpl_at)
	)
	(print "------------------------------------------------------------")
	
	
)

(defun calcLochbildDaten (Lchb_ID BlechHT BlechAT)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID 
		(S_Bez   "M20")
		(Guete   "4.6")
		(e       "-1 1 0 0 0 0")
		(w       "80  0")
	)
	
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v)
				r_winkel_at	(Traeger.get Tr_ID r_winkel)
				h_at				(Traeger.get Tr_ID h)
				b_at				(Traeger.get Tr_ID b)
				s_at				(Traeger.get Tr_ID s)
	)
	
	(setq delta_v_ht 	(Traeger.get Htrg delta_v)
				r_winkel_ht	(Traeger.get Htrg r_winkel)
				h_ht				(Traeger.get Htrg h)
				b_ht				(Traeger.get Htrg b)
				s_ht				(Traeger.get Htrg s)
	)
	
	(setq dp_blechHT 	(Blech.get BlechHT dp)
				bp_blechHT	(Blech.get BlechHT bp)
	)
	(setq dp_blechAT 	(Blech.get BlechAT dp)
				bp_blechAT	(Blech.get BlechAT bp)
	)
	
	; magebenden Trger ermitteln (hier der kleinere)
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg rechts)))
	
	(setq vscherl_at (TrEnde.get TrgEnde_AT vscherl))
	(setq vscherl_ht (TrEnde.get TrgEnde_HT vscherl))
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(setq vscherl_ht_halb (* 0.5 vscherl_ht))
	
	(setq vwnkl_ht				(TrEnde.get TrgEnde_HT v_winkel))
	(print vwnkl_ht)
	(if (> vwnkl_ht 90.0)
		(setq wnkl_ht (- vwnkl_ht 90.0))
		(setq wnkl_ht (- 90.0 vwnkl_ht))
	)
	(print wnkl_ht)
	
	(setq tanW_ht (tan (/ (* PI wnkl_ht) 180.0)))
	(print tanW_ht)
	
	; Anteil Neigung 
	(setq antW (* dp_blechHT tanW_ht))
	(print antW)
	
	
	(if (< vscherl_at vscherl_ht)
		(progn
			(setq h_prof_mass vscherl_at)
			(setq h_prof vscherl_ht)
		)
		(progn
			(setq h_prof_mass vscherl_ht)
			(setq h_prof vscherl_at)
		)
	)
					
	
	;(setq ueb 5)	;; nur zum Testen - Kopfplattenposition zum Traeger
	
	(setq massAbstand (* 0.25 minDiff))
	
	(setq viertel (* 0.25 h_prof_mass))
	(print viertel)
	(setq viertel massAbstand)
	(print viertel)
	
	;(setq e0 (+ diff viertel))
	
	(if (> oKante_ht oKante_at)
		(setq e0 (+ viertel diff_oben antW))
		(setq e0 (+ viertel antW))
	)
	
	;(setq e0rund (runde e0 auf 5))
	(print e0)
	(setq e1 (* 2 viertel))
	(print e1)
	
	(if (< bp_blechAT bp_blechHT)
		(setq b_mass bp_blechAT)
		(setq b_mass bp_blechHT)
	)
	(if (< s_at s_ht)
		(setq s_mass s_at)
		(setq s_mass s_ht)
	)
	
	(setq w0 (* 0.5 (- b_mass s_mass)))
	
	(Lochbild.set Lchb_ID (e0 		e0) 
												(e1 		e1)
												(w0			w0) 
												(klemml (+ dp_blechHT dp_blechaT))
	)
	
	(if (= LB_DEBUG 1)
		(Lochbild.set Lchb_ID (e2 400))
	)
	
	(print "<-----------------------------------------------------------")
)

(defun createLochbild (Lchb_ID)
	(print ">-----------------------------------------------------------")	
	(print "ERZEUGE LOCHBILD")
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(traeger.addabtl Htrg Lchb_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
  	(traeger.addabtl Htrg Lchb_ID 0.0 0.0 _kpllochbildrechts_)
  )
  
  (if (= (Connect.get CastaData LinkesEnde) 1)
		(traeger.addabtl Tr_ID Lchb_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
  	(traeger.addabtl Tr_ID Lchb_ID 0.0 0.0 _kpllochbildrechts_)
  )
	
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID rechts)))
	
  (setq dp_blech (Blech.get atkpl dp))
	
	(setq vwnkl_at (TrEnde.get AtEnde v_winkel))
	(print vwnkl_at)
	
	(if (>= vwnkl_at 90.0)
		(setq wnkl_at (- vwnkl_at 90.0))
		(setq wnkl_at (- 90.0 vwnkl_at))
	)
	(print wnkl_at)
	
	(setq tanW_at (tan (/ (* PI wnkl_at) 180.0)))
	(print tanW_at)
	
	(setq antW_At (* dp_blech tanW_at))
	(print antW_At)
	(print diff_oben)
	(print oKante_at)
	(print oKante_ht)
	(if (> oKante_at oKante_ht)
		(setq delta_v_abtl (- (+ diff_oben antW_At) antW) )
		(setq delta_v_abtl (- (+ (- diff_oben) antW_At) antW))
	)
	(print delta_v_abtl)
	
	
    
    
  (setq Abtl_KplLchb (traeger.get Htrg ABTeil Lchb_ID))
  (Anbauteil.set Abtl_KplLchb (Master 1)
															(delta_v delta_v_abtl)
	)
  (setq Abtl_KplLchb_at (traeger.get Tr_ID ABTeil Lchb_ID))
  (Anbauteil.set Abtl_KplLchb_at 	(Master 0))
  
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy Lchb_ID)
						
			(if (= (connect.get CastaData LinkesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
    	)
	    (if (= (connect.get CastaData RechtesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
	    )
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1))
			
		)
	)
	;===================================================================
  (print "------------------------------------------------------------")
) 
	
(defun korrKplFuerAndereProfile (BLECH_HT BLECH_AT)	
	(setq qsform_at (Traeger.get Tr_ID qsform))
	(setq qsform_ht	(Traeger.get Htrg qsform))
	(setq KastenProfilAnschluss 0)
	(if (= qsform_at "K") (setq KastenProfilAnschluss 1))
	(if (= qsform_ht "K") (setq KastenProfilAnschluss 1))
	(if (= KastenProfilAnschluss 1) (progn


		(setq sd (Lochbild.get kpl_lb sdurchm))
	
		(setq bp (Blech.get BLECH_HT bp))
		(setq w0 (+ bp (* 4 sd)))
		(setq bp (+ bp (* 8 sd)))

		(Blech.set BLECH_HT (bp bp))
		(Blech.set BLECH_AT (bp bp))
		(Lochbild.set kpl_lb (w0 w0))
	))
)

	

(defun berechneTraegerUnterschiede ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE TRGERUNTERSCHIEDE")
	
	(setq h_kpl_ht 	(Blech.get htkpl hp)
				dp_kpl_ht	(Blech.get htkpl dp)
	)
	(setq h_kpl_at 	(Blech.get atkpl hp)
				dp_kpl_at	(Blech.get atkpl dp)
	)
	
	(setq h_ht 				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
				rwinkel_ht	(Traeger.get Htrg r_winkel)
	)
	
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				rwinkel_at	(Traeger.get Tr_ID r_winkel)
	)
	
	(setq rwinkel_ht_rot (+ rwinkel_ht 180.0))
	
	(if (= rwinkel_at rwinkel_ht_rot)
		(setq delta_v_at (- delta_v_at))
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg rechts)))
	
	(setq vscherl_at 	(TrEnde.get TrgEnde_AT vscherl)		
				vwinkel_at	(TrEnde.get TrgEnde_AT v_winkel)
	)
	(setq vscherl_ht 	(TrEnde.get TrgEnde_HT vscherl)
				vwinkel_ht	(TrEnde.get TrgEnde_HT v_winkel)
	)
	
	(print vscherl_at)
	(print vscherl_ht)
	
	(print vwinkel_at)
	(print vwinkel_ht)
	
	(setq winkel_ht (- 90.0 vwinkel_ht))
	(setq winkel_at (- vwinkel_at 90.0))
	
	(print winkel_at)
	(print winkel_ht)
	
	(if (< winkel_ht 0.0)
		(setq winkel_ht (- winkel_ht))
	)
	(if (< winkel_at 0.0)
		(setq winkel_at (- winkel_at))
	)
	(print winkel_at)
	(print winkel_ht)
	
	(setq tanVW_at	(tan (/ (* PI winkel_at) 180.0)))
	(setq tanVW_ht	(tan (/ (* PI winkel_ht) 180.0)))
	(setq cosVW_at	(cos (/ (* PI winkel_at) 180.0)))
	(setq cosVW_ht	(cos (/ (* PI winkel_ht) 180.0)))
	(print tanVW_ht)
	(print tanVW_at)
	(print cosVW_ht)
	(print cosVW_at)
	
	(print dp_kpl_ht)
	(print dp_kpl_at)
	
	; Anteil der Kopfplattendicke
	(setq anteil_kpl_ht (* dp_kpl_ht tanVW_ht))
	(setq anteil_kpl_at (* dp_kpl_at tanVW_at))
	
	(print anteil_kpl_ht)
	(print anteil_kpl_at)
		
	(if (< vscherl_at vscherl_ht)
		(progn
			(setq h_prof_mass vscherl_ht)			
			(setq h_prof vscherl_at)
			(setq isHtrg 1)
			(Blech.set atkpl (hp h_kpl_ht))
		)
		(progn
			(setq h_prof_mass vscherl_at)
			(setq h_prof vscherl_ht)
			(setq isHtrg 0)
			(Blech.set htkpl (hp h_kpl_at))
		)
	)
	
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(setq vscherl_ht_halb (* 0.5 vscherl_ht))
	
	(setq delta_v_ht_scher (/ delta_v_ht cosVW_ht))
	(setq delta_v_at_scher (/ delta_v_at cosVW_at))
	
	(print delta_v_ht_scher)
	(print delta_v_at_scher)
	
	; Oberkante der Trger
	(setq oKante_ht (- delta_v_ht_scher vscherl_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht vscherl_ht))										(print uKante_ht)
	(setq oKante_at	(- delta_v_at_scher vscherl_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at vscherl_at))										(print uKante_at)
		
	(print "-----------------------------------")
	
	; Anteil der Kopfplatte hinzurechnen
	(setq oKante_ht (+ oKante_ht anteil_kpl_ht))								(print oKante_ht)
	(setq uKante_ht (+ uKante_ht anteil_kpl_ht))								(print uKante_ht)
	(setq oKante_at	(+ oKante_at anteil_kpl_at))								(print oKante_at)
	(setq uKante_at (+ uKante_at anteil_kpl_at))								(print uKante_at)
	
	; Differenz oben
	(if (< oKante_ht oKante_at)
		(setq diff_oben (- oKante_at oKante_ht))
		(setq diff_oben (- oKante_ht oKante_at))
	)
	(print diff_oben)
	
  ; Differenz unten
	(if (< uKante_ht uKante_at)
		(setq diff_unten (- uKante_at uKante_ht))
		(setq diff_unten (- uKante_ht uKante_at))
	)
	(print diff_unten)
	
	; Maximal- / Minimalwerte ermitteln (okante / ukante)
	(if (<= oKante_ht oKante_at)
		(progn
			(setq max_oKante oKante_ht)
			(setq min_oKante oKante_at)
		)
		(progn
			(setq max_oKante oKante_at)
			(setq min_oKante oKante_ht)
		)
	)
	(if (>= uKante_ht uKante_at)
		(progn
			(setq max_uKante uKante_ht)
			(setq min_uKante uKante_at)
		)
		(progn
			(setq max_uKante uKante_at)
			(setq min_uKante uKante_ht)
		)
	)
	(print max_oKante)
	(print max_uKante)
	(print min_oKante)
	(print min_uKante)
		
	(setq maxDiff (- max_oKante max_uKante))
	(setq minDiff (- min_oKante min_uKante))
	(print maxDiff)
	(print minDiff)
	
	(if (< maxDiff 0.0)
		(setq maxDiff (- maxDiff))
	)
	(if (< minDiff 0.0)
		(setq minDiff (- minDiff))
	)
	(print maxDiff)
	(print minDiff)
	(print "<-----------------------------------------------------------")
)
