; $	HT	QT(IURK)		AF(S)		P(E)
; $	AT	QT(IURK)		AF(K)		P(E)
; $ AE	V(-)			H(-)		R(90)

; ----------------------------------------------------------------------------------------
;	Einbindung externer Module
; ----------------------------------------------------------------------------------------
(defun load-modules ()
   (load "mod-endinit-uz-uz-gehrung")
   (load "mod-utils")
)

(defun init-connection ()

   (print "*clear*")
  (print "in init-connection - (Gehrungs-Sto h)");
   (Connect.showAttributes CastaData)

	(init-traegerenden)
	
  ;(connect.showattributes CastaData)
  (setq kpl (Blech.create))
  (Connect.storeAnschlObjs CastaData kpl)
  
  (createKopfplatte kpl)
  (korrKplFuerAndereProfile kpl)
  
  
  ; CALLBACKS
  (Blech.set kpl (formFkt "cb_kpl"))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_kpl (zp)
	(print "in Callback-Funktion cb_kpl")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	    	(setq dpDiff (- dpNeu dpAlt))
	       
				; HT
				; ----------------------------------------
	    	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq HT_Ende (Traeger.get Htrg links)))
	    	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq HT_Ende (Traeger.get Htrg rechts)))       
	    	
	    	(TrEnde.ptrim HT_Ende (- (* dpDiff 0.5)))
	      
	      ; AT
				; ----------------------------------------
	      (if (= (Connect.get CastaData LinkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	    	(if (= (Connect.get CastaData RechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))       
	    	
	    	(TrEnde.ptrim AT_Ende (* dpDiff 0.5))
	      
	    ))
	))
)



(defun createKopfplatte (BLECHID)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE KOPFPLATTE")
	
	(setq h_ht 	(Traeger.get Htrg h)
				t_ht	(Traeger.get Htrg t)
	)
	(setq h_at	(Traeger.get Tr_ID h)
				t_at	(Traeger.get Tr_ID t)
	)
	
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq HtEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq HtEnde (Traeger.get Htrg rechts))
	)
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq hscherl_ht (TrEnde.get HtEnde hscherl))
	(setq hscherl_at (TrEnde.get AtEnde hscherl))
	
	(if (>= hscherl_ht hscherl_at)
		(setq hscherl_mass hscherl_ht)
		(setq hscherl_mass hscherl_at)
	)
	
	(setq kpl_bp hscherl_mass)
	
	(if (>= h_ht h_at)
		(setq h_mass h_ht) 
		(setq h_mass h_at)
	)
	
	(setq kpl_hp h_mass)
	
	(if (>= t_ht t_at)
		(setq t_mass t_ht)
		(setq t_mass t_at)
	)
	
	(setq kpl_dp t_mass)
	
	(Blech.set BLECHID 	(hp kpl_hp)
											(bp kpl_bp)
											(dp kpl_dp)
	)
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(Traeger.addabtl Htrg BLECHID xPos_ht 0.0 _kopfplattelinks_)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(Traeger.addabtl Htrg BLECHID xPos_ht 0.0 _kopfplatterechts_)
	)
	
	(TrEnde.ptrim AtEnde (* 0.5 kpl_dp))
	(TrEnde.ptrim HtEnde (* 0.5 kpl_dp))  
	
	; Testweise Implementierung U-Profile
	(setq qsform_at (Traeger.get Tr_ID qsform))
	
	(if (= qsform_at "U")
		(progn
			
			(setq delta_lr_blech (* 0.5 kpl_bp))
			
			(Blech.set BLECHID (delta_lr delta_lr_blech))
		)
	)
	
	(print "------------------------------------------------------------")
)

(defun korrKplFuerAndereProfile (Bl_ID)	
	(setq qsform_at (Traeger.get Tr_ID qsform))
	(setq qsform_ht	(Traeger.get Htrg qsform))
	(setq KastenProfilAnschluss 0)
	(if (= qsform_at "K") (setq KastenProfilAnschluss 1))
	(if (= qsform_ht "K") (setq KastenProfilAnschluss 1))
	(if (= KastenProfilAnschluss 1) (progn
		
		(setq bp (Blech.get Bl_ID bp))
		(setq bp (+ bp 20))

		(Blech.set Bl_ID (bp bp))
	))
)
