(defun init-connection ()

  (print "in init-connection - uz_uz_kpl_stoss");

  (setq TrTest (traeger.create))
  (setq TrLi   (trende.create))

  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))

  (setq HTrLinks   (traeger.get htrg links))
  (setq HTrRechts  (traeger.get htrg rechts))

  (print htrg);
  (print an_seite)

  ; Bedeutung an_seite
  ; 10 - links zwischendurch
  ; 11 - links an linkes Ende des Haupttrgers
  ; 12 - links an rechtes Ende des Haupttrgers
  ; 20 - rechts zwischendurch
  ; 21 - rechts an linkes Ende des Haupttrgers
  ; 22 - rechts an rechtes Ende des Haupttrgers
  ;
  (setq _links 1 _rechts 2)

  (if (= an_seite 22) (setq ept_HTrg _rechts ept_ATrg _rechts))
  (if (= an_seite 21) (setq ept_HTrg _links  ept_ATrg _rechts))
  (if (= an_seite 20) (setq ept_HTrg      0  ept_ATrg _rechts))
  (if (= an_seite 12) (setq ept_HTrg _rechts ept_ATrg _links))
  (if (= an_seite 11) (setq ept_HTrg _links  ept_ATrg _links))
  (if (= an_seite 10) (setq ept_HTrg      0  ept_ATrg _links))

  (print PI)

  (setq h1        (Traeger.get Tr_ID h)
        h2        (Traeger.get HTrg  h)
        alfa_rad  (atan (/ h1 h2))
        alfa      (/ (* alfa_rad 180.0) PI)
  )
  (print alfa)
  (print vwnkl_aflch)

  (if (= ept_ATrg _links) 
    (progn					(print "Anschluss links am Anschlusstrger")
	(if (> vwnkl_aflch 180.0) (setq vwnkl_aflch (- vwnkl_aflch 180.0)))

	(setq diffWinkel (- vwnkl_aflch 90.0))

	(setq Profil (traeger.get hTrg Profil))
	(setq hProf (traeger.get hTrg h))
	(setq  delta_L (/ hProf 2.0))
	(trende.set     TrLinks (delta_l 0))
	
	(setq fakt 0.5)	 ; Damit funktioniert es schon mal auf jeden Fall
	; Hier mal checken, ob man den Faktor nicht besser entwickeln kann
	(if (< h1 h2)
	    (setq fakt (* 0.5 (/ h1 h2)))
	    (setq fakt (* 0.5 (/ h2 h1)))
	)
	
	(setq alfa_1 (+ alfa (* fakt  diffWinkel)))
	(trende.set     TrLinks (V_Winkel (- 180.0 alfa_1)))
	; Kommt auch darauf an, wie der Rotationswinkel liegt.
	(if (= ept_HTrg _rechts) 
	    (progn
	        (print "in ept_HTrg _rechts")
		(setq hProf (traeger.get tr_id h))
		(setq  delta_L (- (/ hProf 2.0)))
		(setq delta_L_alt (TrEnde.get HTrRechts delta_l))
		; ist negativ - deswegen so rum abfragen. Wenn das Ende zu kurz ist, dann
		; muss es verlngert werden.
		(trende.set  HTrRechts (delta_l 0))

		(setq alfa_2 (- alfa (* (- 1.0 fakt)  diffWinkel)))
		; Man muss noch unterscheiden nach Rotationswinkel
		(print "--------------------------------")
		(setq rWnkl (Traeger.get HTrg R_Winkel))
		(print rWnkl)

;		(trende.set  HTrRechts (V_Winkel (+ 90.0 alfa_2)))
		
		(trende.set  HTrRechts (V_Winkel (- 90.0 alfa_2)))
	    )
	)
	(if (= ept_HTrg _links) 
	    (progn
		(setq hProf (traeger.get tr_id h))
		(setq  delta_L (- (/ hProf 2.0)))
		(setq delta_L_alt (TrEnde.get HTrRechts delta_l))
		; ist negativ - deswegen so rum abfragen. Wenn das Ende zu kurz ist, dann
		; muss es verlngert werden.

		(setq alfa_2 (- alfa (* (- 1.0 fakt)  diffWinkel)))
		(trende.set  HTrLinks (delta_l 0))
		(trende.set  HTrLinks (V_Winkel (+ 90.0 alfa_2)))
	    )
	)
    )
  )


  (if (= ept_ATrg _rechts) 
    (progn					(print "Anschluss rechts am Anschlusstrger")
    						(print vwnkl_aflch)
	(if (> vwnkl_aflch 180.0) (setq vwnkl_aflch (- vwnkl_aflch 180.0)))

	(setq diffWinkel (- 90.0 vwnkl_aflch))
	(setq diffWinkel (- vwnkl_aflch 90.0))
	(print vwnkl_aflch)
	(print diffWinkel)

	(setq Profil (traeger.get hTrg Profil))
	(setq hProf (traeger.get hTrg h))
	(setq  delta_L (/ hProf 2.0))

	(setq fakt 0.5)		;; Damit funktioniert es schon mal
	; Hier mal checken, ob man den Faktor nicht besser entwickeln kann
	(if (< h1 h2)
	    (setq fakt (* 0.5 (/ h1 h2)))
	    (setq fakt (* 0.5 (/ h2 h1)))
	)

	
	(setq alfa_1 (- alfa (* fakt  diffWinkel)))
								(print alfa_1)
	(trende.set     TrRechts (delta_l 0))
	(trEnde.set     TrRechts (V_Winkel alfa_1))
	(if (= ept_HTrg _rechts) 
	    (progn
		(setq hProf (traeger.get tr_id h))
		(setq  delta_L (- (/ hProf 2.0)))
		(setq delta_L_alt (TrEnde.get HTrRechts delta_l))
		; ist negativ - deswegen so rum abfragen. Wenn das Ende zu kurz ist, dann
		; muss es verlngert werden.

		(setq alfa_2 (+ alfa (* (- 1.0 fakt)  diffWinkel)))
		(trende.set  HTrRechts (delta_l 0))
		(trende.set  HTrRechts (V_Winkel (+ 90.0 alfa_2)))
	    )
	)
	(if (= ept_HTrg _links) 
	    (progn
		(setq hProf (traeger.get tr_id h))
		(setq  delta_L (- (/ hProf 2.0)))
		(setq delta_L_alt (TrEnde.get HTrRechts delta_l))
		; ist negativ - deswegen so rum abfragen. Wenn das Ende zu kurz ist, dann
		; muss es verlngert werden.

		(setq alfa_2 (+ alfa (* (- 1.0 fakt)  diffWinkel)))
		(trende.set  HTrLinks (delta_l 0))
		(trende.set  HTrLinks (V_Winkel (- 90.0 alfa_2)))
	    )
	)
    ) ; progn
  )
  

  
)
