; $ G(20)	HT	QT(IUKR)	AF(FS)		P(EZ)
; $ G(20)	AT	QT(L)		AF(FS)		P(E)
; $ G(20)	AE	V(-)		H(-)		R(-)
; $	HT	QT(F)	AF(K)		P(E)
; $	AT	QT(RS)	AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

(defun load-modules ()
  ; Profil prfen
  (setq qsform_at (Traeger.get Tr_ID qsform))
  (print qsform_at)
  
  ; (load "mod-lochbild")
)

(defun init-connection ()

  (print "*clear*")
  (print "********************************************************************")
  (print "in init-connection - swStab an Flachstahl Kopfverbindung");

  (setq Anschluss_Erzeugen 1)
  (if (= (Connect.get CastaData  vatr-vhtr)  0) (setq  Anschluss_Erzeugen 0))
  
  (if (= Anschluss_Erzeugen 0) (progn
		 (AlertBox "Anschluss wird nicht erstellt!\nDer Winkel in der Windverbandsebene ist unpassend." "ERR_AngleInPlaneProblem")
   ))

   (connect.ShowAttributes CastaData)

  (if (= Anschluss_Erzeugen 1) (progn
		(createObjekte)
		(createAnbauteilObjekte)
  ))
  
)

(defun	createObjekte ()
   	(setq vLochbild	    (Lochbild.create))
  	(setq augenBlech	(Blech.create))
  	(Connect.storeAnschlObjs CastaData vLochbild augenBlech) 

	; Lochbild initlialisieren
    (Lochbild.set  vLochbild (S_Bez "M12") (Guete "4.6") (e "0 15 85 0 0 0") (w "0 0"))

	; Blechgren initlialisieren ...
	(Blech.set augenBlech (dp 10) (hp 100) (bp 50))
	(Blech.set augenBlech (Lschlitz 50) (hp 150))

	(setq dv_AT (Traeger.get Tr_ID delta_V)
				t_AT	(Traeger.get Tr_ID t)
	)
	(setq dv_HT (Traeger.get HTrg  delta_V)
				t_HT	(Traeger.get HTrg  t)
	)
	
	; Noch checken, wenn der AT auf der anderen Seite liegt - hngt vom dv_AT zu dv_HT ab.
	(setq dp_Min 1)
	(if  (= (Connect.get CastaData  vatr-vhtr)  -1) (progn
		(setq dp_Min  (* 2 (-  (+ dv_AT dv_HT)    (* 0.5  t_HT ))))
		(AlertBox dp_Min)
	))
	(if  (= (Connect.get CastaData  vatr-vhtr)   1) (progn
		(setq dp_Min  (* 2 (-   (* 0.5  t_HT )  (+ dv_AT dv_HT))))
		(AlertBox dp_Min)
	))
	(Blech.set  augenBlech (dp dp_Min))
	
	
)

(defun	createAnbauteilObjekte ()


	
		; Anbauteil hinzufgen
	(setq WINDVERBAND_LB 0)
	(if (= (Connect.get CastaData linkesEnde) 1)  (setq WINDVERBAND_LB _windvblchb_flansch_links_))
	(if (= (Connect.get CastaData rechtesEnde) 1)  (setq WINDVERBAND_LB _windvblchb_flansch_rechts_))
	
    (if (/= WINDVERBAND_LB 0) 	(Traeger.addabtl Tr_ID vLochbild 0.0 0.0 WINDVERBAND_LB))

	(setq xPos_LB 0.0)
	(setq w_Lchb_HT 0.0)
	(if (= (Connect.get CastaData anHTLinkesEnde) 1)  (progn
			(setq xPos_LB  0.0)
			(setq w_Lchb_HT 180.0)
	))
	(if (= (Connect.get CastaData anHTrechtesEnde) 1)  (progn
			(setq xPos_LB  (Traeger.get HTrg sysLng))
			(setq w_Lchb_HT 0.0)
	))
	 
	(traeger.addabtl HTrg vLochbild xPos_LB 	w_Lchb_HT 	_flanschlochbild_of_)	

	
   (setq abtl_Lchb_AT (Traeger.get  Tr_ID  ABTeil  vLochbild))
   (setq abtl_Lchb_HT (Traeger.get  HTrg  ABTeil  vLochbild))
   
	(if (= (Connect.get CastaData linkesEnde) 1)  (progn
		(Anbauteil.set  abtl_Lchb_AT (Winkel 0.0))
		(Anbauteil.set  abtl_Lchb_HT (Seitricht  -1))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1)  (progn
		(Anbauteil.set  abtl_Lchb_AT (Winkel 180.0))
		(Anbauteil.set  abtl_Lchb_HT (Seitricht  -1))
	))
   
	; Auswhlen, welchens der beiden Lochbuilder im 3D zu sehen ist
   (Anbauteil.set  abtl_Lchb_AT (Master 	0))
   (Anbauteil.set  abtl_Lchb_HT (Master 	1))
   
   (Lochbild.set  vLochbild  (w0 20))
   (setq t_HT (Traeger.get HTrg t)
			 dp	(Blech.get  augenBlech dp)
   )
   (AlertBox dp)
	(Lochbild.set  vLochbild (KlemmL (+ dp t_HT))
									  (dxSKopf dp)
	)
	
	
  (if (= (Connect.get CastaData linkesEnde) 1)
  	(traeger.addabtl tr_id augenBlech 0.0 0.0 _augenblech_links_)
  )
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(traeger.addabtl tr_id augenBlech 0.0 0.0 _augenblech_rechts_)
  )

	; Weil die Add-Routine das Blech initlialisiert
	(Blech.set  augenBlech (dp dp))
  
  

)

; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Knotenblech am HT
; ----------------------------------------------------------------------------------------
(defun cb_augenBlech (zp)
	(print "in Callback-Funktion cb_knotenBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get cb_augenBlech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get knotenBlech dp))
	    
	    (if (/= dpAlt dpNeu) (progn
			(print dpAlt) (print dpNeu)
	    ))
	))
)


