; $	HT	QT(I)			AF(F)			P(ZE)
; $	AT	QT(Z)			AF(FS)		P(ZE)
; $ 	AE	V(-)			H(0)			R(-)

;	Achtung - Quelldatei wird auch fr Z-Profile verwendet. Dort wird sie komplett eingebunden.

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
	(load "mod_CZ_PfettenanschlussMitFahne")
	
	; eingeladen wird ......
	; setConnection
	; calcLichtenAbst
	; calcFutterBlech    - wird nicht verwendet
	; createFutterBlech  - wird nicht verwendet
	; setAnbauteilBlech
	; setFahnenblechLochbild
	; sucheFahnenBlech
	
)

(defun init-connection ()
	
	(print "*clear*")
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	(if (= (Connect.get CastaData amATFlansch) 1)
		(if (= (Connect.get CastaData vatr-vhtr) -1)
			(alertBox "Der Anschluss ist z.Z. in dieser Kombination nicht mglich.\n\nBitte rotieren Sie die Trger so, dass die hellen bzw. dunklen Flanschseiten\nin eine Richtung zeigen und tauschen Sie, falls ntig, die Orientierung eines Trgers."  "ERR_BeamRoation_Not_Functional")
			(progn
				(setq Schrb_Default "M12")
			    (LageAnalyse)  ; ermittelt HT_RechteSeite HT_LinkeSeite
				(if (= AT_DurchLaufend 0) (progn
					(setConnection)
					(Blech.set Fahnenbl  (FormFkt "cb_FahnenblechFlansch"))
					; (calcBlechVersatz Fahnenbl)
					; (HT_Lochbild_Neigung)
					; (SchraubenVersatz_im_HT)
					(CreateFahnenBl_Ht)	; muss zuerst eingesetzt werden um Winkeldaten daraus zu berechnen
					(CreateWinkel)
					(setLochbildDaten)
					(setBlechVersatz)
					(SchrbLaengs_FahneWinkel)
				))

				(if (= AT_DurchLaufend 1) (progn
					(alertBox "Anschluss nicht mglich!" "Connection_Not_Possible")
				))
			)
		)
	)
	
)

(defun setLochbildDaten ()

	(setq dw     (Winkel.get wZugWinkel_1 dw))
	(setq dp_FBl (Blech.get FahnBl_HT_1 dp))
	(setq s_AT   (Traeger.get Tr_ID s))

	(if (= HT_LinkeSeite  1) (Lochbild.set Wnkl_Lchb_1_1 (Klemml (+ dw s_AT))))
	(if (= HT_RechteSeite 1) (Lochbild.set Wnkl_Lchb_1_2 (Klemml (+ dw s_AT))))

	(if (= HT_LinkeSeite  1) (Lochbild.set Wnkl_Lchb_1_2 (Klemml (+ dw dp_FBl))))
	(if (= HT_RechteSeite 1) (Lochbild.set Wnkl_Lchb_1_1 (Klemml (+ dw dp_FBl))))
)


(defun	SchrLaengsLage_imHT ()
	(setq dlr_Trg (Traeger.get Tr_ID delta_LR))
	(setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	(setq rWinkel (Anbauteil.get AbtlFahnenLb_HT Winkel))
	
	(if (= (Connect.get CastaData  satr-lhtr) -1) (progn
		(if (< rWinkel -85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX    dlr_Trg)))
		(if (> rWinkel  85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX (- dlr_Trg))))
	))
	(if (= (Connect.get CastaData  satr-lhtr)  1) (progn
		(if (< rWinkel -85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX (- dlr_Trg))))
		(if (> rWinkel  85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX    dlr_Trg)))
	))
)
(defun HT_Lochbild_Neigung ()

	(setq AbtlFahnenLb_AT	(Traeger.get Tr_ID AbTeil lchbAtrgSteg))
	(setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	(setq rWinkel_Lchb_AT (Anbauteil.get  AbtlFahnenLb_AT Winkel))
	(print  rWinkel_Lchb_AT)
	
;	(Anbauteil.set AbtlFahnenLb_AT (Master 0))
;	(Anbauteil.set AbtlFahnenLb_HT (Master 1))
	
	(if (= (Connect.get CastaData sAtr-lHtr) -1) (progn
		(if (= rWinkel_Lchb_AT 180.0)  (Anbauteil.set  AbtlFahnenLb_HT (neigwnkl_d (- nWinkel))))
		(if (= rWinkel_Lchb_AT    0.0)  (Anbauteil.set  AbtlFahnenLb_HT (neigwnkl_d     nWinkel)))
	))
	(if (= (Connect.get CastaData sAtr-lHtr)  1) (progn
		(if (= rWinkel_Lchb_AT    0.0)  (Anbauteil.set  AbtlFahnenLb_HT (neigwnkl_d (- nWinkel))))
		(if (= rWinkel_Lchb_AT  180.0)  (Anbauteil.set  AbtlFahnenLb_HT (neigwnkl_d     nWinkel)))
	))
	
)
; ----------------------------------------------------------------------------------------
(defun SchraubenVersatz_im_HT ()
	(setq AbtlFahnenLb_AT	(Traeger.get Tr_ID AbTeil lchbAtrgSteg))
	(setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	(setq abtl_FahnenBl (Traeger.get HTrg  ABTeil  Fahnenbl))
	(setq nWinkel (Anbauteil.get AbtlFahnenLb_HT neigwnkl_d))

	(setq dlr_Lchb (Anbauteil.get AbtlFahnenLb_HT delta_LR))

	(setq sinW (sin (/ (* PI nWinkel) 180.0)))
	(setq cosW (cos (/ (* PI nWinkel) 180.0)))
	(setq tanW (tan (/ (* PI nWinkel) 180.0)))
	(setq h_AT 		(Traeger.get Tr_ID h)
		  dv_AT		(Traeger.get Tr_ID delta_V)
		  dlr_AT	(Traeger.get Tr_ID delta_LR)
	)
	(setq h_HT 		(Traeger.get HTrg h)
		  dv_HT		(Traeger.get HTrg delta_V)
	)

	(setq abst_auf_Flansch (* (+ (* 0.5 h_HT) (- dv_HT (* 0.5 h_HT))) tanW))
	(setq dsx_HT 	(* abst_auf_Flansch cosW))
	(setq dsxVA_HT  (* abst_auf_Flansch sinW))

	(if (= (Connect.get CastaData amHtOberFlansch) 1) (progn
		(setq Versatz (- (* -1.0 dv_AT) (* 0.5 h_AT) (/ (- (* 0.5 h_HT) dv_HT) cosW)))
	))
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) (progn
		(setq Versatz (- (* 1.0 dv_AT) (* 0.5 h_AT) (/ (- (* 0.5 h_HT) (- dv_HT)) cosW)))
		(setq dsxVA_HT  (- dsxVA_HT))
	))
	
	
	(setq dlr_Lchb_Neu 0.0)
	
;	(Anbauteil.set AbtlFahnenLb_AT (master 0))
;	(Anbauteil.set AbtlFahnenLb_HT (master 1))
;	(Lochbild.set lchbAtrgSteg (e "0 25 75 0 0 0"))	; ----------- Testwerte
;	(Lochbild.set lchbAtrgSteg (w "0 100"))	; ----------- Testwerte
;	(Lochbild.set lchbAtrgSteg (dxSKopf 0.0))

	(if (= (Connect.get CastaData vatr-vhtr) 1) (progn
		(setq dlr_Lchb_Neu Versatz)
		(setq dlr_Lchb_Neu (- dlr_Lchb_Neu dsxVA_HT))
		(setq dsx_HT 	(- dsx_HT))
	))
	
	; bei Z-Pfetten muss dies im Gegensatz zu C-Pfetten abgezogen werden
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(setq s_AT (Traeger.get Tr_ID s))
		(setq dp_Bl (Blech.get Fahnenbl dp))
		(setq dsx_HT (- dsx_HT s_AT dp_Bl))
	))
	
	(Anbauteil.set AbtlFahnenLb_HT (delta_sx dsx_HT))
	(Anbauteil.set AbtlFahnenLb_HT (delta_LR dlr_Lchb_Neu))
	
	
)
; ----------------------------------------------------------------------------------------

; -------------------------------------------------------------
(defun applyTo_ZProfile (Blech_ID Lchb_ID)

  (setq dlr_Trg (Traeger.get Tr_ID delta_LR))

  (setq qsForm (Traeger.get Tr_ID QSForm))
  (if (= qsForm "Z") (progn
	(if (= FB_Vorhanden 0) (progn
		(setq xBlech 	(Blech.get Blech_ID xAsym)
		      dp	(Blech.get Blech_ID dp)
		      s_At	(Traeger.get Tr_ID s)
		)
		(setq xBlech_Neu 0)
		(if (= (Connect.get CastaData satr-lhtr)  1) (setq xBlech_Neu (+ (*  0.5 dp) (* 0.5 s_AT))))
		(if (= (Connect.get CastaData satr-lhtr) -1) (setq xBlech_Neu (- (* -0.5 dp) (* 0.5 s_AT))))
		
		(if (= (Connect.get CastaData satr-lhtr)  1) (setq xBlech_Neu (+ xBlech_Neu dlr_Trg)))
		(if (= (Connect.get CastaData satr-lhtr) -1) (setq xBlech_Neu (- xBlech_Neu dlr_Trg)))

		(if (= (Connect.get CastaData amhtUnterFlansch) 1) (progn
			(setq xBlech_Neu (- xBlech_Neu))
		))
		
		(Blech.set Blech_ID (xAsym xBlech_Neu))
	))
	(Lochbild.set Lchb_ID (dxSKopf (* 0.5 s_AT)))
	(if (= (Connect.get CastaData amhtUnterFlansch) 1) (progn
		(setq dp	(Blech.get Blech_ID dp))
		(Lochbild.set Lchb_ID (dxSKopf (+ (* 0.5 s_AT) dp)))
	))
   ))  

)


; -------------------------------------------------------------
; Setzt das Anbauteil fr das Blech
; -------------------------------------------------------------
(defun	calcBlechVersatz (Blech_ID)

	(setq	delta_LR_Blech (Blech.get Blech_ID dp))
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_LR_Blech (* -0.5 delta_LR_Blech)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_LR_Blech (*  0.5 delta_LR_Blech)))

	(setq dlr_Trg (Traeger.get Tr_ID delta_LR))
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_LR_Blech (+ delta_LR_Blech dlr_Trg)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_LR_Blech (- delta_LR_Blech dlr_Trg)))

	(setq nWinkel  0.0)
	(calc_Neigungswinkel)			; hier wird nWinkel bestimmt
	(setq abtl_FahnenBl (Traeger.get HTrg  ABTeil  Blech_ID))
	
	(Anbauteil.set abtl_FahnenBl 	
					(neigwnkl_d		nWinkel)
	)

	(if (/= nWinkel 0.0) (progn
		(setq dv_HT (Traeger.get HTrg delta_V))
		(setq dv_HT (* 1.0 dv_HT))
		(if (/= dv_HT 0.0) (progn
			(setq tan_NW (tan (* PI (/ nWinkel 180.0))))
			(setq dlr_Korr (* dv_HT tan_NW))
			(setq  delta_LR_Blech (- delta_LR_Blech dlr_Korr))
		))
	))

	; Korrektur bei Z-Profilen - bei C-Profile liegt die Fahne auf der anderen Seite
	(setq s_AT (Traeger.get Tr_ID s))
	(setq dp_Bl (Blech.get Fahnenbl dp))
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_LR_Blech (+ delta_LR_Blech s_AT dp_Bl)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_LR_Blech (- delta_LR_Blech s_AT dp_Bl)))
	
	(print delta_LR_Blech)
	(Blech.set Blech_ID (xAsym delta_LR_Blech))
	
)

; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT Flansch
; ----------------------------------------------------------------------------------------
(defun  cb_FahnenblechFlansch (zp)
	(if (= zp 0) (progn
	    (setq dpAlt		(Blech.get Fahnenbl dp))
	))
	(if (= zp 1) (progn
	    (setq dpNeu		(Blech.get Fahnenbl dp))
		
		(if (/= dpAlt dpNeu) (progn
			(FahnBlFlansch_Anpassen dpAlt dpNeu)
			(aendereFahnenBlechLochbilder dpAlt dpNeu)
		))
	))

)

(defun FahnBlFlansch_Anpassen (dpAlt dpNeu)
	(setq currXAsym (Blech.get Fahnenbl xAsym))
	(setq newxAsym  0.0)
	(if (= (Connect.get CastaData sAtr-lHtr)  1)	(setq newxAsym (+ currXAsym (* 0.5 (- dpNeu dpAlt)))))
	(if (= (Connect.get CastaData sAtr-lHtr) -1)	(setq newxAsym (- currXAsym (* 0.5 (- dpNeu dpAlt)))))
	(Blech.set Fahnenbl (xAsym newxAsym))

	; (setq currKlemmLng (Lochbild.get lchbAtrgSteg KlemmL))
	; (setq newKlemmLng (+ currKlemmLng (- dpNeu dpAlt)))
	; (Lochbild.set lchbAtrgSteg (KlemmL newKlemmLng))
)
(defun aendereFahnenBlechLochbilder (dpAlt dpNeu)

  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesKnoBlTyp (+ _fahnbllochbild_ _oberflansch_)))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesKnoBlTyp (+ _fahnbllochbild_ _oberflansch_)))

  (setq abtl_FaLb (Traeger.get Htrg firstAbtl Lochbild (- xPos_HT 0.5) (+ xPos_HT 0.5)))
  (while abtl_FaLb
  	(setq sType     (Anbauteil.get abtl_FaLb is_type gesKnoBlTyp))
  	(if (= sType 1) (progn
	    (print "FahnenBlechlochbild gefunden -----------------------------------------------------")
	    (print sType)
	    (setq LchbID (Anbauteil.get abtl_FaLb objekt Lochbild))
	    (setq alteKlemmLnge (Lochbild.get LchbID Klemml))
	    (Lochbild.set LchbID (Klemml (+ alteKlemmLnge (- dpNeu dpAlt))))
	))
  	(setq abtl_FaLb (Traeger.get Htrg nextAbtl Lochbild))
  )

)

; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_FahnenblechSeite (zp)
	(print "*clear*")
	(print "in Callback-Funktion cb_FahnenblechSeite")
	(print zp)

;	(if _CopyAction_ (print "CopyAction - Kopieren wird ausgefhrt!"))

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq hpAlt		(Blech.get FahnBl_HT_1 hp))
	    (setq dpAlt		(Blech.get FahnBl_HT_1 dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
		(LageAnalyse)
	    (setq hpNeu (Blech.get FahnBl_HT_1 hp))
	    (setq dpNeu (Blech.get FahnBl_HT_1 dp))
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       ; Anbauteil wird in der folgenden Routine gebraucht
;	       (setq AbtlFahnenLchb	(Traeger.get Htrg AbTeil lchbAtrgSteg))
;	       (calcSchrLaengeUndVersatz lchbAtrgSteg)
	       ; (calcBlechVersatz Fahnenbl)
	       ; (aendereFahnenBlechLochbilder dpAlt dpNeu)
		   (setLochbildDaten)	; Klemmlngen
		   (setBlechVersatz)
	    ))
	    ; (SchrLaengsLage_imHT)
		; (SchraubenVersatz_im_HT)
	    (if (/= hpAlt hpNeu) (progn
			(Fahnenblech_set_DOK FahnBl_HT_1 hpNeu)
		))

	))
)

(defun Fahnenblech_set_DOK (FahnBl_HT hp)
	(setq 	h_HT (Traeger.get HTrg h)
			t_HT (Traeger.get HTrg t)
	)
	; erstmal prfen, ob Blech berhaupt zwischen die Flansche passt
	(setq hp_Max (- h_HT t_HT t_HT))
	(if (> hp hp_Max) (progn
		(setq hp hp_Max)
		(Blech.set FahnBl_HT (hp hp_Max))
	))

	; dann dOK ausrechnen und eintragen
	(setq RestAbst (- h_HT t_HT t_HT hp))
	(setq dOK_Neu (* 0.5 RestAbst))
	(Blech.set FahnBl_HT (dOK dOK_Neu))

	; und dann noch die Eckabschrgungen anpassen
	(if (> dOK_Neu (+ t_HT  10)) (progn
		(Blech.set FahnBl_HT (x3 0) (y3 0))
	))
	(if (< dOK_Neu (+ t_HT  5)) (progn
		(setq r_HT (Traeger.get HTrg r))
		(Blech.set FahnBl_HT (x3 (+ r_HT 3)) (y3 (+ r_HT 3)))
	))

)


(defun calcSchrLaengeUndVersatz (Lchb_ID dpAlt dpNeu)

    (if (= dpAlt 0) (progn
     (setq dp		(Blech.get Fahnenbl dp)
           s_AT 	(Traeger.get Tr_ID  s)
           KlemmLng	(+ dp s_AT)
     )
     (Lochbild.set Lchb_ID (Klemml KlemmLng))
   )
   (progn
     (aendereFahnenBlechLochbilder dpAlt dpNeu)  
   ))
     
)
(defun calc_Neigungswinkel ()
	(setq  tmp_Winkel (Connect.get CastaData  R-AtrGeWnkl_Steg))

	; schauen, ob es fr alle Flle gilt
	(setSteigungsFlag)
	
	(if (= flag_Steigung_HT 1) (progn
		(setq  nWinkel  (- tmp_Winkel 90.0))
	))
	(if (= flag_Steigung_HT -1) (progn
		(setq  nWinkel  (- (- tmp_Winkel 90.0)))
	))
	
	(if (= (Connect.get CastaData  satr-lhtr) 1) (progn
		(setq  nWinkel  (- (- tmp_Winkel 90.0)))
	))
	(if (= (Connect.get CastaData satr-lhtr) -1) (progn
		(setq  nWinkel  (- tmp_Winkel 90.0))
	))

)
(defun	setSteigungsFlag ()
	(setq vwinkel_ht (Connect.get CastaData hpttrg_vwinkel))
	(setq  flag_Steigung_HT 1)
	(if (> vwinkel_ht 270.0)  (setq  flag_Steigung_HT -1))		; wenn HT-Profil schrg nach unten luft
	(if (< vwinkel_ht   0.0)  (setq  flag_Steigung_HT -1))		; wenn HT-Profil schrg nach unten luft
)


(defun aendereFahnenBlechLochbilder (dpAlt dpNeu)

  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesKnoBlTyp (+ _fahnbllochbild_ _oberflansch_)))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesKnoBlTyp (+ _fahnbllochbild_ _oberflansch_)))

  (setq abtl_FaLb (Traeger.get Htrg firstAbtl Lochbild (- xPos_HT 0.5) (+ xPos_HT 0.5)))
  (while abtl_FaLb
  	(setq sType     (Anbauteil.get abtl_FaLb is_type gesKnoBlTyp))
  	(if (= sType 1) (progn
	    (print "FahnenBlechlochbild gefunden -----------------------------------------------------")
	    (print sType)
	    (setq LchbID (Anbauteil.get abtl_FaLb objekt Lochbild))
	    (setq alteKlemmLnge (Lochbild.get LchbID Klemml))
	    (Lochbild.set LchbID (Klemml (+ alteKlemmLnge (- dpNeu dpAlt))))
	))
  	(setq abtl_FaLb (Traeger.get Htrg nextAbtl Lochbild))
  )

)

(defun CreateWinkel ()

	(setq SecondConnection 0)
	(if (objexist wZugWinkel_1)	 (setq SecondConnection 1))
	
	(setq wZugWinkel_1		(Winkel.create))		;
	(print "Default Winkeldaten")
	(setq Wnkl_Lng   100.0)
	(setq rWnkl_SWnk   0.0)
	
	(Winkel.set wZugWinkel_1 (wanz 1) (l 100) (profil "L50*7"))

	(setq Wnkl_Lchb_1_1		(Lochbild.create))
	(setq Wnkl_Lchb_1_2		(Lochbild.create))
	(Lochbild.set Wnkl_Lchb_1_1 (S_Bez Schrb_Default) (Guete "4.6"))
	(Lochbild.set Wnkl_Lchb_1_2 (S_Bez Schrb_Default) (Guete "4.6"))
	
	(calcWinkelDaten 0 30.0) ; w0 muss noch der Default-Wert ermittelt werden

	(setq b_Wnkl (Winkel.get wZugWinkel_1 slk))
	(Lochbild.set Wnkl_Lchb_1_1 (w0 0) (e0 0))
	(Lochbild.set Wnkl_Lchb_1_2 (w0 0) (e0 Ges_Abst_Lchb))
	
	(if (= SecondConnection 0) (Connect.storeAnschlObjs CastaData  wZugWinkel_1 Wnkl_Lchb_1_1 Wnkl_Lchb_1_2))
	(if (= SecondConnection 1) (progn
		; muss mit kleinem Trick gearbeitet werden, Variablen hin und her schaufeln
		; damit sie in die Liste bernommen werden
		(setq wZugWinkel_2 wZugWinkel_1)
		(setq Wnkl_Lchb_2_1 Wnkl_Lchb_1_1)
		(setq Wnkl_Lchb_2_2 Wnkl_Lchb_1_2)
		(setq wZugWinkel_1 nil) 
		(setq Wnkl_Lchb_1_1 nil) 
		(setq Wnkl_Lchb_1_2 nil) 
		(Connect.storeAnschlObjs CastaData  wZugWinkel_2 Wnkl_Lchb_2_1 Wnkl_Lchb_2_2)
		(setq wZugWinkel_1 wZugWinkel_2) 
		(setq Wnkl_Lchb_1_1 Wnkl_Lchb_2_1) 
		(setq Wnkl_Lchb_1_2 Wnkl_Lchb_2_2) 
	))
	
	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(setq xPos_Wnkl xPos_AT)
	
	(if (= HT_RechteSeite 1)  (progn
		(setq xPos_Wnkl (+ xPos_AT Ges_Abst_H))
		(setq rWnkl_SWnk   (+ 90.0 Alfa_w))
		(Winkel.set wZugWinkel_1 
			(l Ges_Abst_Lchb)
			(dOK (* -0.5 Ges_Abst_Lchb))
			(Achsab (* -0.5 b_Wnkl))
		)
	))
	(if (= HT_LinkeSeite 1) (progn
		(setq xPos_Wnkl (- xPos_AT Ges_Abst_H))
		(setq rWnkl_SWnk   (- 90.0 Alfa_w))
		(Winkel.set wZugWinkel_1 
			(l Ges_Abst_Lchb)
			(dOK (* 0.5 Ges_Abst_Lchb))
			(Achsab (* -0.5 b_Wnkl))
		)
	))
	
	(Traeger.addabtl Tr_ID wZugWinkel_1  xPos_Wnkl rWnkl_SWnk _winkel_steg_rechts_)
	
	
	(setq Abtl_Wnkl (Traeger.get Tr_ID AbTeil wZugWinkel_1))
	; xPos und Rotationswinkel werden vom Daddy (Winkel) bernommen
	(Traeger.addabtl Tr_ID Wnkl_Lchb_1_1 0 0 _winkel_traegerlb_ Abtl_Wnkl)
	(Traeger.addabtl Tr_ID Wnkl_Lchb_1_2 0 0 _winkel_traegerlb_ Abtl_Wnkl)

	; Achtung - kleiner Trick: Erst die Schrauben einfgen, dann die Lnge des Winkels
	; ndern, weil beim Einfgen die Schrauben sich am aktuellen Winkel orientieren
	(setq Wnkl_Lng (+ Ges_Abst_Lchb 48))
	(Winkel.set wZugWinkel_1 (l Wnkl_Lng))
	
	(Lochbild.set Wnkl_Lchb_1_1 (FormFkt "cb_PfettenLchb_$lb"))
	(Lochbild.set Wnkl_Lchb_1_2 (FormFkt "cb_PfettenLchb_$lb"))

	; (setq xPos_Wnkl_Test (Anbauteil.get Abtl_Wnkl xPos))
	; (AlertBox xPos_Wnkl_Test)
	; (AlertBox Ges_Abst_H)
	(Winkel.set wZugWinkel_1 (FormFkt "cb_Winkel_1"))

)

(defun CreateFahnenBl_Ht ()
    (setq h_HT (Traeger.get HTrg h)
	      b_HT (Traeger.get HTrg b)
		  s_HT (Traeger.get HTrg s)
		  t_HT (Traeger.get HTrg t)
		  r_HT (Traeger.get HTrg r)
		  quer_HT (Traeger.get HTrg qsForm) 
	)

	(setq b_FBl (/ (- b_HT s_HT) 2))
	(setq h_FBl (- h_HT t_HT t_HT))
	(setq e_FBl (+ r_HT 3))
	
	(setq FahnBl_HT_1 (Blech.create))
	(Blech.set FahnBl_HT_1 (bp b_FBl) (hp h_FBl) (dp 10))
	(Blech.set FahnBl_HT_1 (x2 e_FBl) (y2 e_FBl) (x3 e_FBl) (y3 e_FBl))

	(setq xPos_HT (Connect.get CastaData xPos_HT))
	
	(if (= (Connect.get CastaData sAtr-lHtr) -1) (progn
		(if (= HT_RechteSeite 1)  (progn
				(Traeger.addabtl HTrg FahnBl_HT_1 xPos_HT 90 _fahnenblech_steg_re_)
		))
		(if (= HT_LinkeSeite 1)  (progn
				(Traeger.addabtl HTrg FahnBl_HT_1 xPos_HT 90 _fahnenblech_steg_li_)
		))
	))
	(if (= (Connect.get CastaData sAtr-lHtr) 1) (progn
		(if (= HT_RechteSeite 1)  (progn
				(Traeger.addabtl HTrg FahnBl_HT_1 xPos_HT 90 _fahnenblech_steg_li_)
		))
		(if (= HT_LinkeSeite 1)  (progn
				(Traeger.addabtl HTrg FahnBl_HT_1 xPos_HT 90 _fahnenblech_steg_re_)
		))
	))
	
	(setq FahnLchb_HT (Lochbild.create))
	(Lochbild.set FahnLchb_HT 
			(Anz_S  1)
			(S_Bez Schrb_Default)
			(Guete "4.6")
			(Klemml 0)
			(FormFkt "cb_FahnLchb_$lb")
	)
	(setq AbtlFahnenBl (Traeger.get HTrg AbTeil FahnBl_HT_1))
	(Traeger.addabtl Htrg FahnLchb_HT xPos_HT 0.0 _fahnblLochbild_ AbtlFahnenBl)
	
	(Connect.storeAnschlObjs CastaData  FahnBl_HT_1 FahnLchb_HT)
	(Blech.set FahnBl_HT_1  (FormFkt "cb_FahnenblechSeite"))

)

(defun LageAnalyse ()
    ; initialisieren
	; linke Seite bedeutet, wenn man auf die offene Seite der Z-Pfette schaut, dann 
	; schliet die Pfette am HT links an
	(setq HT_RechteSeite 0	      HT_LinkeSeite  0   AT_DurchLaufend  0)
	
	(if (= (Connect.get CastaData at-von-links) 1)  (progn
	    (if (= (Connect.get CastaData linkesEnde) 1)   (setq HT_RechteSeite 1))
	    (if (= (Connect.get CastaData rechtesEnde) 1)  (setq HT_LinkeSeite 1))
		(if (= HT_LinkeSeite HT_RechteSeite)           (setq AT_DurchLaufend 1))
	))
	(if (= (Connect.get CastaData at-von-rechts) 1)  (progn
	    (if (= (Connect.get CastaData linkesEnde) 1)   (setq HT_LinkeSeite  1))
	    (if (= (Connect.get CastaData rechtesEnde) 1)  (setq HT_RechteSeite 1))
		(if (= HT_LinkeSeite HT_RechteSeite)           (setq AT_DurchLaufend 1))
	))
	; obiges gilt fr sAtr-lHtr = -1
	; Fall ergnzen durch sAtr-lHtr = 1
	(if (= (Connect.get CastaData satr-lhtr) 1) (progn
		(setq HT_RechteSeite_C 0 HT_LinkeSeite_C 0)
		(if (= HT_RechteSeite 1) (setq HT_RechteSeite_C 0 HT_LinkeSeite_C 1))
		(if (= HT_LinkeSeite 1)  (setq HT_RechteSeite_C 1 HT_LinkeSeite_C 0))
		(setq HT_LinkeSeite  HT_LinkeSeite_C)
		(setq HT_RechteSeite HT_RechteSeite_C)
	))

	
)

(defun LageDurchlaufenderAT (abtlLochb)
	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(setq xPos_Lchb (Anbauteil.get abtlLochb xPos))
	(if (= (Connect.get CastaData at-von-links) 1) (progn
		; AT kommt von links
		(if (> xPos_Lchb xPos_AT) (setq HT_RechteSeite 1))
		(if (< xPos_Lchb xPos_AT) (setq HT_LinkeSeite 1))
	))
	(if (= (Connect.get CastaData at-von-rechts) 1) (progn
		; AT kommt von rechts
		(if (< xPos_Lchb xPos_AT) (setq HT_RechteSeite 1))
		(if (> xPos_Lchb xPos_AT) (setq HT_LinkeSeite 1))
	))

	;; (AlertBox HT_LinkeSeite) (AlertBox HT_RechteSeite)
	
)

(defun calcWinkelDaten (iFlag dValue)
	(setq h_HT 		(Traeger.get HTrg  h)
		  s_HT		(Traeger.get HTrg  s)
	      dv_HT 	(Traeger.get HTrg  delta_V)
		  dv_HT		(* 1.0 dv_HT)
	)
	(setq h_AT 		(Traeger.get Tr_ID h)
	      dv_AT 	(Traeger.get Tr_ID  delta_V)
		  dv_AT		(* 1.0 dv_AT)
	)
	(setq w0   (Lochbild.get FahnLchb_HT w0))
	(setq e0   (Lochbild.get FahnLchb_HT e0))
	
	(setq Spalt (- (- dv_HT dv_AT) (/ (+ h_HT h_AT) 2)))
	(setq ML_Abstand (+ Spalt (/ (+ h_HT h_AT) 2)))
	(setq Ges_Abst_V (+ ML_Abstand e0))
	
	(if (= iFlag 0) (progn
		(setq Alfa_w dValue) 
		(setq sinAlfaW (sin (/ (* PI Alfa_w) 180.0)))
		(setq tanAlfaW (tan (/ (* PI Alfa_w) 180.0)))
		(setq Ges_Abst_H (+ (/ Ges_Abst_V tanAlfaW) w0 (* 0.5 s_HT)))
		(setq Ges_Abst_Lchb (/ Ges_Abst_V sinAlfaW))
	))
	(if (= iFlag 1) (progn
		(LageAnalyse)
		(setq Ges_Abst_H 0.0)
		(setq xPos_AT (Connect.get CastaData xPos_AT))
		(if (= HT_LinkeSeite 1)  (setq Ges_Abst_H (- xPos_AT dValue)))
		(if (= HT_RechteSeite 1) (setq Ges_Abst_H (- dValue  xPos_AT)))

		(setq tanAlfaW (/ Ges_Abst_V (- Ges_Abst_H w0 (* 0.5 s_HT))))
		(setq Alfa_w (* 180.0 (/ (atan tanAlfaW) PI)))
		(setq sinAlfaW (sin (/ (* PI Alfa_w) 180.0)))
		(setq Ges_Abst_Lchb (/ Ges_Abst_V sinAlfaW))
	))
	(if (= iFlag 2) (progn
		(setq Ges_Abst_Lchb dValue)
		(setq sinAlfaW (/ Ges_Abst_V Ges_Abst_Lchb))
		(setq Alfa_w (* 180.0 (/ (asin sinAlfaW) PI)))
		(setq cosAlfaW (cos (/ (* PI Alfa_w) 180.0)))
		(setq Ges_Abst_H (+ (* cosAlfaW Ges_Abst_Lchb)  w0 (* 0.5 s_HT)))
	))

	(print "---------------------------- Kontrolle - Start")
	(print Spalt) (print ML_Abstand) (print e0)
	(print ".")
	(print Ges_Abst_H) (print Ges_Abst_V)
	(print Ges_Abst_Lchb) (print Alfa_w)
	
	(print "---------------------------- Kontrolle - Ende")
)

(defun cb_Winkel_1 (zp)
	(print "Callback cb_Winkel_1")
	
	(if (= zp 2) (progn
		(if (= (Connect.get CastaData CopyMode) 1) (progn
			(AlertBox "Copy-Action Winkel")
			(LageAnalyse)
			(setq e0_1 (Lochbild.get Wnkl_Lchb_1_1 e0))
			(setq e0_2 (Lochbild.get Wnkl_Lchb_1_2 e0))
			
			; (lochbild.set Wnkl_Lchb_1_1 (e0 e0_2))
			; (lochbild.set Wnkl_Lchb_1_2 (e0 e0_1))
		))
	))

	(if (= zp 0) (progn
		(setq dw_Alt (Winkel.get wZugWinkel_1 dw))
	))
	(if (= zp 1) (progn
		(setq dw_Neu (Winkel.get wZugWinkel_1 dw))
		
		(if (/= dw_Alt dw_Neu) (progn
			(LageAnalyse)
			(setLochbildDaten) ; Klemmlngen
		))
	))


)

(defun cb_FahnLchb_$lb (zp)
	(print "Fahnenlochbild - Winkelbefestigung am HT - Callback")
	
	(setq CopyActive (Connect.get CastaData CopyMode))
	(if (= CopyActive 1) (setq zp 10))
	(if (= zp 10) (print "Callback wird nicht ausgefhrt"))

	
	(if (= zp 0) (progn
		(setq e0_Alt 	(Lochbild.get FahnLchb_HT e0))
		(setq w0_Alt 	(Lochbild.get FahnLchb_HT w0))
		(setq SBez_Alt	(Lochbild.get FahnLchb_HT S_Bez))
	))
	(if (= zp 1) (progn
		(setq e0_Neu 	(Lochbild.get FahnLchb_HT e0))
		(setq w0_Neu 	(Lochbild.get FahnLchb_HT w0))
		(setq SBez_Neu	(Lochbild.get FahnLchb_HT S_Bez))

		(if (/= SBez_Alt SBez_Neu) (progn
			(LageAnalyse)
			(if (= HT_LinkeSeite 1)  (progn
				(Lochbild.set Wnkl_Lchb_1_2 (S_Bez SBez_Neu))
			))
			(if (= HT_RechteSeite 1)  (progn
				(Lochbild.set Wnkl_Lchb_1_1 (S_Bez SBez_Neu))
			))
		))

		(setq NeuBerechnen 0)
		(if (/= e0_Alt e0_Neu) (setq NeuBerechnen 1))
		(if (/= w0_Alt w0_Neu) (setq NeuBerechnen 1))
		(if (= NeuBerechnen 1) (progn
			(setq Abtl_Wnkl (Traeger.get Tr_ID ABTeil wZugWinkel_1))
			(setq Abtl_WLb_1 (Traeger.get Tr_ID AbTeil Wnkl_Lchb_1_1))
			(setq Abtl_WLb_2 (Traeger.get Tr_ID AbTeil Wnkl_Lchb_1_2))

			(setq xPos_Wnkl (Anbauteil.get Abtl_Wnkl xPos))
			(setq wnkl_Lng (Winkel.get wZugWinkel_1 l))
			(setq wnkl_dOK (Winkel.get wZugWinkel_1 dOK))
			
			
			(LageAnalyse)

			(calcWinkelDaten 1 xPos_Wnkl)
			
			(setq sAbst_alt (Lochbild.get Wnkl_Lchb_1_2 e0))
			(setq wLngDiff (- wnkl_Lng sAbst_alt))
			(setq wnkl_Lng_Neu (+ Ges_Abst_Lchb wLngDiff))

			(if (= HT_RechteSeite 1)  (progn
				(Anbauteil.set Abtl_Wnkl (xPos Ges_Abst_H) (Winkel (+ 90.0 Alfa_w)))
				(Winkel.set wZugWinkel_1 
					(l wnkl_Lng_Neu)
					(dOK (* -0.5 (- wnkl_Lng_Neu (* 1.0 wLngDiff))))
				)
				
				(Anbauteil.set Abtl_WLb_1 (Winkel Alfa_w))
				(Anbauteil.set Abtl_WLb_2 (Winkel Alfa_w))

				; dOK_Lchb = -0.5 * ptrWnkl->l + ptrWnkl->dOK
				(setq dOK_Lchb (* -1.0 Ges_Abst_Lchb))

				(Lochbild.set Wnkl_Lchb_1_1 (dOK dOK_Lchb))
				(Lochbild.set Wnkl_Lchb_1_2 (e0 Ges_Abst_Lchb) (dOK dOK_Lchb))
			))
			(if (= HT_LinkeSeite 1)  (progn
				(setq xPos_AT (Connect.get CastaData xPos_AT))
				(setq xPos_Wnkl (- xPos_AT Ges_Abst_H))
				(Anbauteil.set Abtl_Wnkl (xPos xPos_Wnkl) (Winkel (- 90.0 Alfa_w)))
				(Winkel.set wZugWinkel_1 
					(l wnkl_Lng_Neu)
					(dOK (* 0.5 Ges_Abst_Lchb))
				)
1				(Lochbild.set Wnkl_Lchb_1_1 (e0 0))
				(Lochbild.set Wnkl_Lchb_1_2 (e0 Ges_Abst_Lchb))
				
				(Anbauteil.set Abtl_WLb_1 (Winkel (- Alfa_w)))
				(Anbauteil.set Abtl_WLb_2 (Winkel (- Alfa_w)))
			))
		))
	))
)

(defun CopyPostAction ()
	(print "----------------------------------------------------------------")
	(print "hier in CopyPostAction")
	(print "----------------------------------------------------------------")
	(LageAnalyse)
	
	; (calcWinkelDaten 1 xPos_Wnkl)
	; (setq Abtl_Wnkl (Traeger.get Tr_ID ABTeil wZugWinkel_1))
	(setq Abtl_WLb_1 (Traeger.get Tr_ID AbTeil Wnkl_Lchb_1_1))
	(setq Abtl_WLb_2 (Traeger.get Tr_ID AbTeil Wnkl_Lchb_1_2))
	(setq Abtl_Wnkl  (Traeger.get Tr_ID ABTeil wZugWinkel_1))
	
	(setq Schrb_Anpassen 0)
	(setq Wnkl_dOK	(Winkel.get wZugWinkel_1  dOK))
	(setq e0_1 (Lochbild.get Wnkl_Lchb_1_1 e0))
	(setq e0_2 (Lochbild.get Wnkl_Lchb_1_2 e0))
	
	(if (= HT_LinkeSeite 1) (progn
		(print "HT_LinkeSeite")
		(if (< Wnkl_dOK 0) (progn
			(Winkel.set wZugWinkel_1  (dOK (- Wnkl_dOK)))
			(setq Schrb_Anpassen 1)
		))
	))
	(if (= HT_RechteSeite 1)  (progn
		(print "HT_RechteSeite")
		(if (> Wnkl_dOK 0) (progn
			(Winkel.set wZugWinkel_1  (dOK (- Wnkl_dOK)))
			(setq Schrb_Anpassen 1)
		))
	))

	(if (= Schrb_Anpassen 1) (progn
		(setq wnkl_1 (Anbauteil.get Abtl_WLb_1 Winkel))
		(setq wnkl_2 (Anbauteil.get Abtl_WLb_2 Winkel))
		
		(if (< wnkl_1 0) 
			(setq Wnkl_Neu (+ wnkl_1 180.0))
			(setq Wnkl_Neu (- wnkl_1 180.0))
		)
		(Anbauteil.set Abtl_WLb_1 (Winkel Wnkl_Neu))
		(Anbauteil.set Abtl_WLb_2 (Winkel Wnkl_Neu))
		
		(Lochbild.set Wnkl_Lchb_1_1 (e0 e0_2))
		(Lochbild.set Wnkl_Lchb_1_2 (e0 e0_1))
	))

	(setq Wnkl_W (Anbauteil.get Abtl_Wnkl Winkel))
	(print Wnkl_W)
	
	(setq e_Abstand (* 1.0 (- e0_1 e0_2)))
	(if (< e_Abstand 0) (setq e_Abstand (- e_Abstand)))
	; Berechnung der rlevanten Daten
	(calcWinkelDaten 2 e_Abstand)



	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(setq xPos_Wnkl xPos_AT)
	
	(if (= HT_LinkeSeite 1) (progn
		(setq xPos_Wnkl (- xPos_AT Ges_Abst_H))
		(setq rW_Winkel (- 90.0 Alfa_w))
		(setq rW_Lochb  (- Alfa_w))
		(if (= Schrb_Anpassen 1) (setq rW_Lochb (+ rW_Lochb 180.0)))
	))
	(if (= HT_RechteSeite 1)  (progn
		(setq xPos_Wnkl (+ xPos_AT Ges_Abst_H))
		(setq rW_Winkel (+ 90.0 Alfa_w))
		(setq rW_Lochb  Alfa_w)
		(if (= Schrb_Anpassen 1) (setq rW_Lochb (- rW_Lochb 180.0)))
	))
	(Anbauteil.set Abtl_Wnkl (xPos xPos_Wnkl)  (Winkel rW_Winkel))
	(Anbauteil.set Abtl_WLb_1 (xPos xPos_Wnkl) (Winkel rW_Lochb))
	(Anbauteil.set Abtl_WLb_2 (xPos xPos_Wnkl) (Winkel rW_Lochb))


)

(defun cb_PfettenLchb_$lb (zp)
	(print "Fahnenlochbild - Winkelbefestigung am HT - Callback")

	(LageAnalyse)
	(if (= AT_DurchLaufend 1) (progn
		(LageDurchlaufenderAT cb_Objekt)
	))
	(if (= HT_LinkeSeite 1)  (SBezAenderung Wnkl_Lchb_1_2 zp))
	(if (= HT_RechteSeite 1) (SBezAenderung Wnkl_Lchb_1_1 zp))
	
	(if (= AT_DurchLaufend 0) (progn
		(if (= HT_LinkeSeite  1) (progn
			(if (= zp 0) (progn
				(setq e0_vorh_LS (Lochbild.get Wnkl_Lchb_1_2 e0))
			))
			(if (= zp 1) (progn
				(setq e0_neu_LS (Lochbild.get Wnkl_Lchb_1_2 e0))
				(setq eDiff (- e0_vorh_LS e0_neu_LS))
				(if (/= eDiff 0) (progn
					(Lochbild.set Wnkl_Lchb_1_2 (e0 e0_vorh_LS))
					(Lochbild.set Wnkl_Lchb_1_1 (e0 eDiff))
					(print "gendert -1-")
				))
			))
		))
		(if (= HT_RechteSeite 1) (progn
			(if (= zp 0) (progn
				(setq e0_vorh_RS (Lochbild.get Wnkl_Lchb_1_1 e0))
			))
			(if (= zp 1) (progn
				(setq e0_neu_RS (Lochbild.get Wnkl_Lchb_1_1 e0))
				(setq eDiff (- e0_vorh_RS e0_neu_RS))
				(if (/= eDiff 0) (progn
					(setq e0_Mem (Lochbild.get Wnkl_Lchb_1_2 e0))
					(Lochbild.set Wnkl_Lchb_1_2 (e0 (+ e0_Mem eDiff)))
					(Lochbild.set Wnkl_Lchb_1_1 (e0 0))
					(print "gendert -2-")
				))
			))
		))
	
		(if (= HT_LinkeSeite 1)  (PfettenLochbild_CB wZugWinkel_1 Wnkl_Lchb_1_1 zp))
		(if (= HT_RechteSeite 1) (PfettenLochbild_CB wZugWinkel_1 Wnkl_Lchb_1_2 zp))
	))

	; Wird nie der Fall sein (0 oder 1) - daher ausgeklammert
	(if (= AT_DurchLaufend 2) (progn
		(setq cb_LchbObjekt (Anbauteil.get cb_Objekt Objekt lochbild))
		(AlertBox cb_LchbObjekt)
		
		(if (= cb_LchbObjekt Wnkl_Lchb_1_1) (PfettenLochbild_CB wZugWinkel_1 Wnkl_Lchb_1_1 zp))
		(if (= cb_LchbObjekt Wnkl_Lchb_1_2) (PfettenLochbild_CB wZugWinkel_1 Wnkl_Lchb_1_2 zp))

		(if (objexist Wnkl_Lchb_2_1) (progn
			(setq Wnkl_Lchb_1_1 Wnkl_Lchb_2_2)
			(if (= cb_LchbObjekt Wnkl_Lchb_2_1) (PfettenLochbild_CB wZugWinkel_2 Wnkl_Lchb_2_1 zp))
		))
		(if (objexist Wnkl_Lchb_2_2) (progn
			(setq Wnkl_Lchb_1_2 Wnkl_Lchb_2_1)
			(if (= cb_LchbObjekt Wnkl_Lchb_2_2) (PfettenLochbild_CB wZugWinkel_2 Wnkl_Lchb_2_2 zp))
		))
	))

	
)
(defun SBezAenderung (Lchb_ID zp)
	(print "SBezAenderung")
	
	(setq ptrLchb_Obj (Anbauteil.get cb_Objekt objekt Lochbild))
	; (setq SBez_Test (Lochbild.get ptrLchb_Obj S_Bez))
	
	(if (= zp 0) (progn
		(setq SBez_Alt (Lochbild.get Lchb_ID S_Bez))
	))
	(if (= zp 1) (progn
		(setq SBez_Neu (Lochbild.get Lchb_ID S_Bez))
		(if (= HT_LinkeSeite 1) (progn
			(if (= Wnkl_Lchb_1_2 ptrLchb_Obj) (progn 
				(Lochbild.set FahnLchb_HT (S_Bez SBez_Neu))
				(Traeger.set HTrg (achslaenge 0)) ; hat keine Auswirkungen, auer dass das editFlag gesetzt wird
			))
		))
		(if (= HT_RechteSeite 1) (progn
			(if (= Wnkl_Lchb_1_1 ptrLchb_Obj) (progn
				(Lochbild.set FahnLchb_HT (S_Bez SBez_Neu))
				(Traeger.set HTrg (achslaenge 0)) ; hat keine Auswirkungen, auer dass das editFlag gesetzt wird
			))
		))
	))

)
(defun PfettenLochbild_CB (wZugWinkel_ID Lchb_ID zp)
	(print "PfettenLochbild_CB")
	
	(if (= zp 0) (progn
		(setq e0_Alt (Lochbild.get Lchb_ID e0))
		(setq w0_Alt (Lochbild.get Lchb_ID w0))
	))
	(if (= zp 1) (progn
		(setq e0_Neu (Lochbild.get Lchb_ID e0))
		(setq w0_Neu (Lochbild.get Lchb_ID w0))
		(setq NeuBerechnen 0)
		(if (/= e0_Alt e0_Neu) (setq NeuBerechnen 1))
		(if (/= w0_Alt w0_Neu) (setq NeuBerechnen 1))
		(if (= NeuBerechnen 1) (progn
			(print "Neu berechnen")
			(setq Abst_e 0)
			(setq wnklUeberstand 0.0)
			(setq wnkl_Lng (Winkel.get wZugWinkel_ID l))
			
			(if (= Wnkl_Lchb_1_1 Lchb_ID) (progn 
				(setq eLchb_2 (Lochbild.get Wnkl_Lchb_1_2 e0))
				(setq Abst_e (* 1.0 (- eLchb_2 e0_Neu)))
				(setq wnklUeberstand (- wnkl_Lng (- eLchb_2 e0_Alt)))
			))
			(if (= Wnkl_Lchb_1_2 Lchb_ID) (progn
				(setq eLchb_2 (Lochbild.get Wnkl_Lchb_1_1 e1))
				(setq Abst_e (* 1.0 (- e0_Neu eLchb_2)))
				(setq wnklUeberstand (- wnkl_Lng (- e0_Alt eLchb_2)))
			))
			
			(calcWinkelDaten 2 Abst_e)
			(setq xPos_AT (Connect.get CastaData xPos_AT))
			(setq xPos_Wnkl xPos_AT)
			(setq wnkl_Lng_Neu (+ Ges_Abst_Lchb wnklUeberstand))
			
			(if (= HT_RechteSeite 1)  (progn
				(setq xPos_Wnkl (+ xPos_AT Ges_Abst_H))
				(setq rWnkl_SWnk   (+ 90.0 Alfa_w))
				(Winkel.set wZugWinkel_ID 
					(l wnkl_Lng_Neu)
					(dOK (* -0.5 (- wnkl_Lng_Neu (* 1.0 wnklUeberstand))))
				)
			))
			(if (= HT_LinkeSeite 1) (progn
				(setq xPos_Wnkl (- xPos_AT Ges_Abst_H))
				(setq rWnkl_SWnk   (- 90.0 Alfa_w))
				(Winkel.set wZugWinkel_ID 
					(l wnkl_Lng_Neu)
					(dOK (* 0.5 Ges_Abst_Lchb))
				)
			))
			
			(setq Lchb_Winkel Alfa_w)	; Default-Wert

			(setq Abtl_WLb_1 (Traeger.get Tr_ID AbTeil Wnkl_Lchb_1_1))
			(setq Abtl_WLb_2 (Traeger.get Tr_ID AbTeil Wnkl_Lchb_1_2))
			(if (= Wnkl_Lchb_1_2 Lchb_ID) (progn
				(Lochbild.set Wnkl_Lchb_1_1 (dOK (- Ges_Abst_Lchb)))
				(Lochbild.set Wnkl_Lchb_1_2 (dOK (- Ges_Abst_Lchb)))

				(setq Lchb_Winkel Alfa_w)
			))
			(if (= Wnkl_Lchb_1_1 Lchb_ID) (progn
				(Lochbild.set Wnkl_Lchb_1_1 (dOK 0) (e0 0))
				(Lochbild.set Wnkl_Lchb_1_2 (dOK 0) (e0 Ges_Abst_Lchb))

				(setq Lchb_Winkel (- Alfa_w))
			))

			(setq Abtl_Wnkl (Traeger.get Tr_ID AbTeil wZugWinkel_ID))
			(Anbauteil.set Abtl_Wnkl (xPos xPos_Wnkl) (Winkel rWnkl_SWnk))

			(Anbauteil.set Abtl_WLb_1 (xPos xPos_Wnkl) (Winkel Lchb_Winkel))
			(Anbauteil.set Abtl_WLb_2 (xPos xPos_Wnkl) (Winkel Lchb_Winkel))


		))
	))


)

(defun setBlechVersatz ()
	(LageAnalyse)
	(setq	s_AT	(Traeger.get Tr_ID s)
			dlr_AT	(Traeger.get Tr_ID delta_LR)
	)
	(setq dp_FBl (Blech.get FahnBl_HT_1 dp))
	(setq SAtrLHtr (Connect.get CastaData satr-lhtr))

	(setq dlr_Abtl 0.0)
	(setq Abtl_FaBl (Traeger.get HTrg AbTeil FahnBl_HT_1))
	(if (objexist Abtl_FaBl) (progn
		(setq dlr_Abtl (Anbauteil.get Abtl_FaBl delta_LR))
	))
	
	(setq Bl_xAsym (- (* 0.5 dp_FBl) (* 0.5 s_AT)))
	(setq Bl_xAsym (- Bl_xAsym dlr_AT))
	
	(if (= SAtrLHtr 1) (setq Bl_xAsym (- Bl_xAsym)))
	
	(if (= HT_LinkeSeite  1) (Blech.set FahnBl_HT_1 (xAsym Bl_xAsym)))
	(if (= HT_RechteSeite 1) (Blech.set FahnBl_HT_1 (xAsym Bl_xAsym)))
	
)
(defun SchrbLaengs_FahneWinkel ()
	(setq SK_Versch_1 0.0)
	(setq dp_FahBl (Blech.get FahnBl_HT_1 dp))
	(setq dw_Wnkl  (Winkel.get wZugWinkel_1 dw))
	
	(LageAnalyse)
	(if (= (Connect.get CastaData sAtr-lHtr) -1) (progn
		(setq SK_Versch_1 (* 1.0 dp_FahBl))
		(if (= HT_LinkeSeite 1)  (Lochbild.set Wnkl_Lchb_1_2 (dxskopf SK_Versch_1)))
		(if (= HT_RechteSeite 1) (Lochbild.set Wnkl_Lchb_1_1 (dxskopf SK_Versch_1)))
	))
	(if (= (Connect.get CastaData sAtr-lHtr) 1) (progn
		(setq SK_Versch_1 (* 0.5 dp_FahBl))
		
		(if (= HT_LinkeSeite 1)  (Lochbild.set Wnkl_Lchb_1_2 (dxskopf dp_FahBl)))
		(if (= HT_RechteSeite 1) (Lochbild.set Wnkl_Lchb_1_1 (dxskopf dp_FahBl)))
	))


)
