; $	HT	QT(IK)			AF(F)			P(ZE)
; $	AT	QT(Z)			AF(FS)		P(ZE)
; $ 	AE	V(-)			H(0)			R(-)

;	Achtung - Quelldatei wird auch fr Z-Profile verwendet. Dort wird sie komplett eingebunden.

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
	(load "mod_CZ_PfettenanschlussMitFahne")
	
	; eingeladen wird ......
	; setConnection
	; calcLichtenAbst
	; calcFutterBlech    - wird nicht verwendet
	; createFutterBlech  - wird nicht verwendet
	; setAnbauteilBlech
	; setFahnenblechLochbild
	; sucheFahnenBlech
	
)

(defun init-connection ()
	
	(print "*clear*")
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	(if (= (Connect.get CastaData amATFlansch) 1)
		(if (= (Connect.get CastaData vatr-vhtr) -1)
			(alertBox "Der Anschluss ist z.Z. in dieser Kombination nicht mglich.\n\nBitte rotieren Sie die Trger so, dass die hellen bzw. dunklen Flanschseiten\nin eine Richtung zeigen und tauschen Sie, falls ntig, die Orientierung eines Trgers."  "ERR_BeamRoation_Not_Functional")
			(progn
				(setConnection)
				(calcBlechVersatz Fahnenbl)
				(SchrLaengsLage_imHT)
				(HT_Lochbild_Neigung)
				(SchraubenVersatz_im_HT)
				(Blech.set Fahnenbl  (FormFkt "cb_Fahnenblech_Z"))
			)
		)
	)
	(if (= (Connect.get CastaData amATSteg) 1) (progn
		  (setConnection)
		  (applyTo_ZProfile Fahnenbl lchbAtrgSteg)
		  (Blech.set Fahnenbl  (FormFkt "cb_Fahnenblech_Z"))
		  (SchrLaengsLage_imHT)
	))

;	(setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil lchbAtrgSteg))
;	(setq dlr_Lchb_HT (Anbauteil.get AbtlFahnenLb_HT delta_LR))
;	(AlertBox dlr_Lchb_HT)
	
)


(defun	SchrLaengsLage_imHT ()
	(setq dlr_Trg (Traeger.get Tr_ID delta_LR))
	(setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	(setq rWinkel (Anbauteil.get AbtlFahnenLb_HT Winkel))

	(if (= (Connect.get CastaData  satr-lhtr) -1) (progn
		(if (< rWinkel -85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX    dlr_Trg)))
		(if (> rWinkel  85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX (- dlr_Trg))))
	))
	(if (= (Connect.get CastaData  satr-lhtr)  1) (progn
		(if (< rWinkel -85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX (- dlr_Trg))))
		(if (> rWinkel  85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX    dlr_Trg)))
	))
)
(defun HT_Lochbild_Neigung ()

	(setq AbtlFahnenLb_AT	(Traeger.get Tr_ID AbTeil lchbAtrgSteg))
	(setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	(setq rWinkel_Lchb_AT (Anbauteil.get  AbtlFahnenLb_AT Winkel))
	(print  rWinkel_Lchb_AT)
	
;	(Anbauteil.set AbtlFahnenLb_AT (Master 0))
;	(Anbauteil.set AbtlFahnenLb_HT (Master 1))
	
	(if (= (Connect.get CastaData sAtr-lHtr) -1) (progn
		(if (= rWinkel_Lchb_AT 180.0)  (Anbauteil.set  AbtlFahnenLb_HT (neigwnkl_d (- nWinkel))))
		(if (= rWinkel_Lchb_AT    0.0)  (Anbauteil.set  AbtlFahnenLb_HT (neigwnkl_d     nWinkel)))
	))
	(if (= (Connect.get CastaData sAtr-lHtr)  1) (progn
		(if (= rWinkel_Lchb_AT    0.0)  (Anbauteil.set  AbtlFahnenLb_HT (neigwnkl_d (- nWinkel))))
		(if (= rWinkel_Lchb_AT  180.0)  (Anbauteil.set  AbtlFahnenLb_HT (neigwnkl_d     nWinkel)))
	))
	
)
; ----------------------------------------------------------------------------------------
(defun SchraubenVersatz_im_HT ()
	(setq AbtlFahnenLb_AT	(Traeger.get Tr_ID AbTeil lchbAtrgSteg))
	(setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	(setq abtl_FahnenBl (Traeger.get HTrg  ABTeil  Fahnenbl))
	(setq nWinkel (Anbauteil.get AbtlFahnenLb_HT neigwnkl_d))

	(setq dlr_Lchb (Anbauteil.get AbtlFahnenLb_HT delta_LR))

	(setq sinW (sin (/ (* PI nWinkel) 180.0)))
	(setq cosW (cos (/ (* PI nWinkel) 180.0)))
	(setq tanW (tan (/ (* PI nWinkel) 180.0)))
	(setq h_AT 		(Traeger.get Tr_ID h)
		  dv_AT		(Traeger.get Tr_ID delta_V)
		  dlr_AT	(Traeger.get Tr_ID delta_LR)
	)
	(setq h_HT 		(Traeger.get HTrg h)
		  dv_HT		(Traeger.get HTrg delta_V)
	)

	(setq abst_auf_Flansch (* (+ (* 0.5 h_HT) (- dv_HT (* 0.5 h_HT))) tanW))
	(setq dsx_HT 	(* abst_auf_Flansch cosW))
	(setq dsxVA_HT  (* abst_auf_Flansch sinW))

	(if (= (Connect.get CastaData amHtOberFlansch) 1) (progn
		(setq Versatz (- (* -1.0 dv_AT) (* 0.5 h_AT) (/ (- (* 0.5 h_HT) dv_HT) cosW)))
	))
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) (progn
		(setq Versatz (- (* 1.0 dv_AT) (* 0.5 h_AT) (/ (- (* 0.5 h_HT) (- dv_HT)) cosW)))
		(setq dsxVA_HT  (- dsxVA_HT))
	))
	
	
	(setq dlr_Lchb_Neu 0.0)
	
;	(Anbauteil.set AbtlFahnenLb_AT (master 0))
;	(Anbauteil.set AbtlFahnenLb_HT (master 1))
;	(Lochbild.set lchbAtrgSteg (e "0 25 75 0 0 0"))	; ----------- Testwerte
;	(Lochbild.set lchbAtrgSteg (w "0 100"))	; ----------- Testwerte
;	(Lochbild.set lchbAtrgSteg (dxSKopf 0.0))

	(if (= (Connect.get CastaData vatr-vhtr) 1) (progn
		(setq dlr_Lchb_Neu Versatz)
		(setq dlr_Lchb_Neu (- dlr_Lchb_Neu dsxVA_HT))
		(setq dsx_HT 	(- dsx_HT))
	))
	
	; bei Z-Pfetten muss dies im Gegensatz zu C-Pfetten abgezogen werden
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(setq s_AT (Traeger.get Tr_ID s))
		(setq dp_Bl (Blech.get Fahnenbl dp))
		(setq dsx_HT (- dsx_HT s_AT dp_Bl))
	))
	
	(Anbauteil.set AbtlFahnenLb_HT (delta_sx dsx_HT))
	(Anbauteil.set AbtlFahnenLb_HT (delta_LR dlr_Lchb_Neu))
	
	
)
; ----------------------------------------------------------------------------------------

; -------------------------------------------------------------
(defun applyTo_ZProfile (Blech_ID Lchb_ID)

  (setq dlr_Trg (Traeger.get Tr_ID delta_LR))

  (setq qsForm (Traeger.get Tr_ID QSForm))
  (if (= qsForm "Z") (progn
	(if (= FB_Vorhanden 0) (progn
		(setq xBlech 	(Blech.get Blech_ID xAsym)
		      dp	(Blech.get Blech_ID dp)
		      s_At	(Traeger.get Tr_ID s)
		)
		(setq xBlech_Neu 0)
		(if (= (Connect.get CastaData satr-lhtr)  1) (setq xBlech_Neu (+ (*  0.5 dp) (* 0.5 s_AT))))
		(if (= (Connect.get CastaData satr-lhtr) -1) (setq xBlech_Neu (- (* -0.5 dp) (* 0.5 s_AT))))
		
		(if (= (Connect.get CastaData satr-lhtr)  1) (setq xBlech_Neu (+ xBlech_Neu dlr_Trg)))
		(if (= (Connect.get CastaData satr-lhtr) -1) (setq xBlech_Neu (- xBlech_Neu dlr_Trg)))

		(if (= (Connect.get CastaData amhtUnterFlansch) 1) (progn
			(setq xBlech_Neu (- xBlech_Neu))
		))
		
		(Blech.set Blech_ID (xAsym xBlech_Neu))
	))
	(Lochbild.set Lchb_ID (dxSKopf (* 0.5 s_AT)))
	(if (= (Connect.get CastaData amhtUnterFlansch) 1) (progn
		(setq dp	(Blech.get Blech_ID dp))
		(Lochbild.set Lchb_ID (dxSKopf (+ (* 0.5 s_AT) dp)))
	))
   ))  

)


; -------------------------------------------------------------
; Setzt das Anbauteil fr das Blech
; -------------------------------------------------------------
(defun	calcBlechVersatz (Blech_ID)

	(setq	delta_LR_Blech (Blech.get Blech_ID dp))
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_LR_Blech (* -0.5 delta_LR_Blech)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_LR_Blech (*  0.5 delta_LR_Blech)))

	(setq dlr_Trg (Traeger.get Tr_ID delta_LR))
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_LR_Blech (+ delta_LR_Blech dlr_Trg)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_LR_Blech (- delta_LR_Blech dlr_Trg)))

	(setq nWinkel  0.0)
	(calc_Neigungswinkel)			; hier wird nWinkel bestimmt
	(setq abtl_FahnenBl (Traeger.get HTrg  ABTeil  Blech_ID))
	
	(Anbauteil.set abtl_FahnenBl 	
					(neigwnkl_d		nWinkel)
	)

	(if (/= nWinkel 0.0) (progn
		(setq dv_HT (Traeger.get HTrg delta_V))
		(setq dv_HT (* 1.0 dv_HT))
		(if (/= dv_HT 0.0) (progn
			(setq tan_NW (tan (* PI (/ nWinkel 180.0))))
			(setq dlr_Korr (* dv_HT tan_NW))
			(setq  delta_LR_Blech (- delta_LR_Blech dlr_Korr))
		))
	))

	; Korrektur bei Z-Profilen - bei C-Profile liegt die Fahne auf der anderen Seite
	(setq s_AT (Traeger.get Tr_ID s))
	(setq dp_Bl (Blech.get Fahnenbl dp))
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_LR_Blech (+ delta_LR_Blech s_AT dp_Bl)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_LR_Blech (- delta_LR_Blech s_AT dp_Bl)))
	

	(Blech.set Blech_ID (xAsym delta_LR_Blech))
	
)


; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_Fahnenblech_Z (zp)
	(print "*clear*")
	(print "in Callback-Funktion cb_bFahnenbl Z")
	(print zp)

;	(if _CopyAction_ (print "CopyAction - Kopieren wird ausgefhrt!"))

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt		(Blech.get Fahnenbl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get Fahnenbl dp))
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       ; Anbauteil wird in der folgenden Routine gebraucht
;	       (setq AbtlFahnenLchb	(Traeger.get Htrg AbTeil lchbAtrgSteg))
;	       (calcSchrLaengeUndVersatz lchbAtrgSteg)
	       (calcBlechVersatz Fahnenbl)
	       (aendereFahnenBlechLochbilder dpAlt dpNeu)
	    ))
	    (SchrLaengsLage_imHT)
		(SchraubenVersatz_im_HT)
	))
	(if (= zp 20) (progn
	    (setq dpNeu (Blech.get Fahnenbl dp))
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
			; Anbauteil wird in der folgenden Routine gebraucht
			(setq AbtlFahnenLchb	(Traeger.get Htrg AbTeil lchbAtrgSteg))
			(calcSchrLaengeUndVersatz lchbAtrgSteg dpAlt dpNeu)
			(setq FB_Vorhanden 0)
			(applyTo_ZProfile Fahnenbl lchbAtrgSteg)
	    ))
	    (SchrLaengsLage_imHT)
	))
)

(defun calcSchrLaengeUndVersatz (Lchb_ID dpAlt dpNeu)

    (if (= dpAlt 0) (progn
     (setq dp		(Blech.get Fahnenbl dp)
           s_AT 	(Traeger.get Tr_ID  s)
           KlemmLng	(+ dp s_AT)
     )
     (Lochbild.set Lchb_ID (Klemml KlemmLng))
   )
   (progn
     (aendereFahnenBlechLochbilder dpAlt dpNeu)  
   ))
     
)
(defun calc_Neigungswinkel ()
	(setq  tmp_Winkel (Connect.get CastaData  R-AtrGeWnkl_Steg))

	; schauen, ob es fr alle Flle gilt
	(setSteigungsFlag)
	
	(if (= flag_Steigung_HT 1) (progn
		(setq  nWinkel  (- tmp_Winkel 90.0))
	))
	(if (= flag_Steigung_HT -1) (progn
		(setq  nWinkel  (- (- tmp_Winkel 90.0)))
	))
	
	(if (= (Connect.get CastaData  satr-lhtr) 1) (progn
		(setq  nWinkel  (- (- tmp_Winkel 90.0)))
	))
	(if (= (Connect.get CastaData satr-lhtr) -1) (progn
		(setq  nWinkel  (- tmp_Winkel 90.0))
	))

)
(defun	setSteigungsFlag ()
	(setq vwinkel_ht (Connect.get CastaData hpttrg_vwinkel))
	(setq  flag_Steigung_HT 1)
	(if (> vwinkel_ht 270.0)  (setq  flag_Steigung_HT -1))		; wenn HT-Profil schrg nach unten luft
	(if (< vwinkel_ht   0.0)  (setq  flag_Steigung_HT -1))		; wenn HT-Profil schrg nach unten luft
)


(defun aendereFahnenBlechLochbilder (dpAlt dpNeu)

  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesKnoBlTyp (+ _fahnbllochbild_ _oberflansch_)))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesKnoBlTyp (+ _fahnbllochbild_ _oberflansch_)))

  (setq abtl_FaLb (Traeger.get Htrg firstAbtl Lochbild (- xPos_HT 0.5) (+ xPos_HT 0.5)))
  (while abtl_FaLb
  	(setq sType     (Anbauteil.get abtl_FaLb is_type gesKnoBlTyp))
  	(if (= sType 1) (progn
	    (print "FahnenBlechlochbild gefunden -----------------------------------------------------")
	    (print sType)
	    (setq LchbID (Anbauteil.get abtl_FaLb objekt Lochbild))
	    (setq alteKlemmLnge (Lochbild.get LchbID Klemml))
	    (Lochbild.set LchbID (Klemml (+ alteKlemmLnge (- dpNeu dpAlt))))
	))
  	(setq abtl_FaLb (Traeger.get Htrg nextAbtl Lochbild))
  )

)
