; $	HT	QT(IK)			AF(F)			P(ZE)
; $	AT	QT(Z)			AF(FS)		P(ZE)
; $ 	AE	V(-)			H(0)			R(-)

;	Achtung - Quelldatei wird auch fr Z-Profile verwendet. Dort wird sie komplett eingebunden.

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
	(load "mod_CZ_PfettenanschlussMitWinkel")
)



(defun init-connection ()

	(print "*clear*")
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	(if (= (Connect.get CastaData amATFlansch) 1) (progn
		(pruefeLage)
		(if (= (Connect.get CastaData vatr-vhtr) -1)
			(alertBox 
				"Der Anschluss ist z.Z. in dieser Kombination nicht mglich.\n\nBitte rotieren Sie die Trger so, dass die hellen bzw. dunklen Flanschseiten\nin eine Richtung zeigen und tauschen Sie, falls ntig, die Orientierung eines Trgers."  
				 "ERR_BeamRoation_Not_Functional")
		)
		(if (= (Connect.get CastaData vatr-vhtr)  1) (progn
				(setConnection)
				(SchrLaengsLage_imHT)
				; (Blech.set Fahnenbl  (FormFkt "cb_Fahnenblech_Z"))
		))
	))
	(if (= (Connect.get CastaData amATSteg) 1) (progn
		  (setConnection)
		  ; (applyTo_ZProfile Fahnenbl lchbAtrgSteg)
		  ; (Blech.set Fahnenbl  (FormFkt "cb_Fahnenblech_Z"))
		  (SchrLaengsLage_imHT)
	))
	
;	(setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil lchbAtrgSteg))
;	(setq dlr_Lchb_HT (Anbauteil.get AbtlFahnenLb_HT delta_LR))
;	(AlertBox dlr_Lchb_HT)

	
)


(defun	SchrLaengsLage_imHT ()
	(setq dlr_Trg (Traeger.get Tr_ID delta_LR))
	(setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	(setq rWinkel (Anbauteil.get AbtlFahnenLb_HT Winkel))
	(if (= (Connect.get CastaData  satr-lhtr) -1) (progn
		(if (< rWinkel -85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX    dlr_Trg)))
		(if (> rWinkel  85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX (- dlr_Trg))))
	))
	(if (= (Connect.get CastaData  satr-lhtr)  1) (progn
		(if (< rWinkel -85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX (- dlr_Trg))))
		(if (> rWinkel  85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX    dlr_Trg)))
	))
)

; -------------------------------------------------------------
(defun applyTo_ZProfile (Blech_ID Lchb_ID)

  (setq dlr_Trg (Traeger.get Tr_ID delta_LR))

  (setq qsForm (Traeger.get Tr_ID QSForm))
  (if (= qsForm "Z") (progn
	(if (= FB_Vorhanden 0) (progn
		(setq xBlech 	(Blech.get Blech_ID xAsym)
		      dp	(Blech.get Blech_ID dp)
		      s_At	(Traeger.get Tr_ID s)
		)
		(setq xBlech_Neu 0)
		(if (= (Connect.get CastaData satr-lhtr)  1) (setq xBlech_Neu (+ (*  0.5 dp) (* 0.5 s_AT))))
		(if (= (Connect.get CastaData satr-lhtr) -1) (setq xBlech_Neu (- (* -0.5 dp) (* 0.5 s_AT))))
		
		(if (= (Connect.get CastaData satr-lhtr)  1) (setq xBlech_Neu (+ xBlech_Neu dlr_Trg)))
		(if (= (Connect.get CastaData satr-lhtr) -1) (setq xBlech_Neu (- xBlech_Neu dlr_Trg)))

		(if (= (Connect.get CastaData amhtUnterFlansch) 1) (progn
			(setq xBlech_Neu (- xBlech_Neu))
		))

		
		(Blech.set Blech_ID (xAsym xBlech_Neu))
	))
	(Lochbild.set Lchb_ID (dxSKopf (* 0.5 s_AT)))
	(if (= (Connect.get CastaData amhtUnterFlansch) 1) (progn
		(setq dp	(Blech.get Blech_ID dp))
		(Lochbild.set Lchb_ID (dxSKopf (+ (* 0.5 s_AT) dp)))
	))
   ))  
   
   
;   (Lochbild.set Lchb_ID (e "0 30 70 0 0 0"))

)


; -------------------------------------------------------------
; Setzt das Anbauteil fr das Blech
; -------------------------------------------------------------


; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_Fahnenblech_Z (zp)
	(print "*clear*")
	(print "in Callback-Funktion cb_bFahnenbl Z")
	(print zp)

;	(if _CopyAction_ (print "CopyAction - Kopieren wird ausgefhrt!"))

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt		(Blech.get Fahnenbl dp))
	    (setq dxs_Alt	(Lochbild.get lchbAtrgSteg dxSKopf))
	    (print dxs_Alt)
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get Fahnenbl dp))
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
		; Anbauteil wird in der folgenden Routine gebraucht
		(setq AbtlFahnenLchb	(Traeger.get Htrg AbTeil lchbAtrgSteg))
		(calcSchrLaengeUndVersatz lchbAtrgSteg dpAlt dpNeu)
		(setq FB_Vorhanden 0)
		(applyTo_ZProfile Fahnenbl lchbAtrgSteg)
	    ))
	    (SchrLaengsLage_imHT)
	))
)

(defun calcSchrLaengeUndVersatz (Lchb_ID dpAlt dpNeu)

    (if (= dpAlt 0) (progn
     (setq dp		(Blech.get Fahnenbl dp)
           s_AT 	(Traeger.get Tr_ID  s)
           KlemmLng	(+ dp s_AT)
     )
     (Lochbild.set Lchb_ID (Klemml KlemmLng))
   )
   (progn
     (aendereFahnenBlechLochbilder dpAlt dpNeu)  
   ))
     
)


(defun aendereFahnenBlechLochbilder (dpAlt dpNeu)

  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesKnoBlTyp (+ _fahnbllochbild_ _oberflansch_)))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesKnoBlTyp (+ _fahnbllochbild_ _oberflansch_)))

  (setq abtl_FaLb (Traeger.get Htrg firstAbtl Lochbild (- xPos_HT 0.5) (+ xPos_HT 0.5)))
  (while abtl_FaLb
  	(setq sType     (Anbauteil.get abtl_FaLb is_type gesKnoBlTyp))
  	(if (= sType 1) (progn
	    (print "FahnenBlechlochbild gefunden -----------------------------------------------------")
	    (print sType)
	    (setq LchbID (Anbauteil.get abtl_FaLb objekt Lochbild))
	    (setq alteKlemmLnge (Lochbild.get LchbID Klemml))
	    (Lochbild.set LchbID (Klemml (+ alteKlemmLnge (- dpNeu dpAlt))))
	))
  	(setq abtl_FaLb (Traeger.get Htrg nextAbtl Lochbild))
  )

)

(defun pruefeLage ()
	(setq Anschluss_Moeglich 0)
	(setq Anschluss_Oberhalb  0)
	(setq Anschluss_Unterhalb 0)
	(if (= (Connect.get CastaData vatr-vhtr) 1) (progn
		(setq dv_HT (Traeger.get HTrg delta_V)
				 h_HT  (Traeger.get HTrg h)
		)
		(setq dv_AT (Traeger.get Tr_ID delta_V)
				 h_AT  (Traeger.get Tr_ID h)
		)
		(setq dv_Versatz (- dv_HT dv_AT))
		(if (>= dv_Versatz (*  0.5 (+ h_HT  h_AT))) (setq Anschluss_Oberhalb 1))
		(if (<= dv_Versatz (* -0.5 (+ h_HT  h_AT))) (setq Anschluss_Unterhalb 1))
		(print dv_Versatz)
		(print Anschluss_Unterhalb)
		(print Anschluss_Oberhalb)
		(if (> Anschluss_Unterhalb 0) (setq Anschluss_Moeglich 1))
		(if (> Anschluss_Oberhalb 0)  (setq Anschluss_Moeglich 1))
	))
	(print  Anschluss_Moeglich)
)

