(defun C:VS_Wsz_in ()
  (setq AlsBlock_Einfuegen 0)
  (setvar "CMDECHO" 1)
  (setq ApplDir (getApplicationDir))
  (setq lstFile (strcat ApplDir "\\vs2acad.lst"))
  (setq CmdListe (read_vs2acad lstFile))
  (if CmdListe (progn
     (if (car CmdListe) (progn
	  (setq CmdListe (eval_ListElements CmdListe))
	  (print CmdListe)
	  (removeInfo lstFile)
	  (write_done_file)
     ))
  ))
  (setvar "CMDECHO" 1)
  (princ "")
)
; ---------------------------------------------------------------------
(defun eval_ListElements (CmdListe / dl)
  (setq cmd_Insert (assoc (quote INSERT_DWG) CmdListe))
  (while cmd_Insert 
    (setq CmdListe (subst (list (quote DONE) (nth 5 cmd_Insert)) cmd_Insert CmdListe))
    (eval cmd_Insert)
    (setq cmd_Insert (assoc (quote INSERT_DWG) CmdListe))
  )
  (setq dl CmdListe)
)
; ---------------------------------------------------------------------
(defun INSERT_DWG (El_ID strScaleFlag PosNr ScaleFaktor dwgFile)
   (princ "\n--------- Start\n")
   (princ "Scale-Flag : ") (princ strScaleFlag) (princ "\n")
   (princ "ScaleFaktor : ") (princ ScaleFaktor) (princ "\n")
   (princ "Filename  : ") (princ dwgFile) (princ "\n")
   (insertWszDwg  dwgFile strScaleFlag ScaleFaktor)
   (princ "--------- Ende\n")
)
; ---------------------------------------------------------------------
(defun insertWszDwg (fileNameAndPath scaleString Skalierfaktor / fp)
  (setq fp (open fileNameAndPath "r"))
  (if fp (progn
	(close fp)
		  
	(setq ElReferenz (entlast))
	; als Block einfgen
	(if (= AlsBlock_Einfuegen 1) (progn
	  	(setq dwgName fileNameAndPath)
		(command "_insert" dwgName (list 0.0 0.0 0.0) 1.0 1.0 0.0)
	))
	; als Einzelelemente einfgen
	(if (= AlsBlock_Einfuegen 0) (progn
		(setq dwgName (strcat "*" fileNameAndPath))
		(command "_insert" dwgName (list 0.0 0.0 0.0) 1.0 0.0)
	))

	(setq _AS (ssadd))
	(if (not ElReferenz) (progn
		(princ "leere - neue - Zeichnung\n")
		(setq e1 (entnext))		 
	     )
	     (progn
		(princ "Elemente in Zeichnung vorhanden\n")
		(setq e1 (entnext ElReferenz))
	     )
	)
	(while e1
		(ssadd e1 _AS)
		(setq e1 (entnext e1))    
	)
	; nur skalieren, wenn Scaleflag dies vorgibt.
	(if (= scaleString "scale_up") (progn
	    (command "_scale" _AS "" (list 0.0 0.0 0.0) Skalierfaktor)
	))

	(command "_move" _AS "" (list 0.0 0.0 0.0) PAUSE)
    ))
  
)
; ---------------------------------------------------------------------
(defun getApplicationDir ( / AppDataFolder)
  (setq AppDataFolder (strcat (getenv "APPDATA") "\\CASta-C\\cadExport"))
)
; ---------------------------------------------------------------------
(defun read_vs2acad (fName / fp)
  (setq fp (open fName "r"))
  (setq rList (list))
  (if fp (progn
    (while (setq rLine (read-line fp))
      	(setq localListElement (read (strcat "(" rLine ")")))
      	(setq rList (append rList (list localListElement)))
    )
    (close fp)
  ))
  (setq rList rList)
)
; ---------------------------------------------------------------------
(defun removeInfo (fName / fp)
  (setq fp (open fName "w"))
  (if fp (progn
      (princ "" fp)
      (close fp)
  ))
)

(defun write_done_file ()
  (setq DoneFileName (strcat (getApplicationDir) "\\ImportStatus.lst"))
  (setq fp (open DoneFileName "a"))
  (if fp (progn
     (while CmdListe
       (setq Elem (car CmdListe))
       (princ "done" fp) (princ " " fp) (princ (car (cdr Elem)) fp) (princ "\n" fp)
       (setq CmdListe (cdr CmdListe))
     )
     (close fp)
  ))
  
)