(defun C:VirtualSteel ()
;  (setq filename "C:/usr/develop/VirtualSteel/Lisp/Uebersicht.3dp")
;  (setq filename "L:/Lisp/Uebersicht.3dp")
  (setq filename (strcat (getCastaC_tmpFolder) "\\Uebersicht.3dp"))

  (setq CntObjsImported 0)
  (setq fp (open filename "r"))

  (if fp (progn
    (read_and_create_Objects fp)
    (close fp)
  ))
  (princ "\n") (princ CntObjsImported ) (princ " Objekte importiert")
  (princ)
)
(defun read_and_create_Objects (fp)
      (setq bReadVertex 0)
      (while (setq line (read-line fp))
	(if (equal line "+OBJEKT START") (progn
		(setq vertexes (list))
		(setq faces (list))
		(setq edges (list))
		(setq objFaces (list))
	))
	(if (equal line "+POLYGON ENDE") (progn
      		(setq bReadVertex 0)
		(setq objFaces (append objFaces (list faces)))
	))

	(if (= bReadVertex 1) (progn
		(setq lVertex (read (strcat "(" line ")") ))

		(setq rList (member lVertex vertexes))
		(if (not rList) (progn
			(setq index (length vertexes))
			(setq vertexes (append vertexes (list lVertex)))
			(setq faces (append faces (list index)))
		))
		(if rList (progn
			(setq index (- (length vertexes) (length rList)))
			(setq faces (append faces (list index)))
		))
		 
	))

	(if (equal line "+POLYGON START") (progn
      		(setq bReadVertex 1)
		(setq faces (list))
	))
	(if (equal line "+OBJEKT ENDE") (progn
		(setq edges (makeEdges objFaces))
		(ent-mesh vertexes objFaces edges)
		(setq CntObjsImported (+ CntObjsImported  1))
		(princ ".")
	))

     )

)

(defun makeEdges (of)
   (setq localEdgeList (list))
   (setq edgesList (list))
   (while of
	(setq sFace (car of))
     	(setq sFace (append sFace (list (car sFace))))

     	(while (>= (length sFace) 2)
	  (setq sEdge         (list (car sFace) (cadr sFace)))

	  (if (not (member sEdge localEdgeList)) (progn
	     (if (not (member (reverse sEdge) localEdgeList)) (progn
	     	(setq edgesList (append edgesList (list (car sFace) (cadr sFace))))
	     	(setq localEdgeList (append localEdgeList (list sEdge)))
	     ))
	  ))
	  
	  (setq sFace (cdr sFace))
	)
     
	(setq of (cdr of))
   )
   (setq edgesList edgesList)
)


  (defun ent-mesh  (vertices faces edges / header ent-list)
	  ;;Entity header:
	  (setq header '((0 . "MESH")
					 (100 . "AcDbEntity")
					 (100 . "AcDbSubDMesh")
					 (71 . 2)
					 (72 . 0)
					 (91 . 0)))
	  ;;Vertices data:
	  (setq ent-list (cons (cons 92 (length vertices)) ent-list))
	  (foreach vertex  vertices
		(setq ent-list (cons (cons 10 vertex) ent-list)))
	  ;;Faces data:
	  (setq
		ent-list (cons (cons 93
							 (+ (length faces)
								(length (apply 'append faces))))
					   ent-list))
	  (foreach face  faces
		(setq ent-list (cons (cons 90 (length face)) ent-list))
		(foreach vertexindex  face
		  (setq ent-list (cons (cons 90 vertexindex) ent-list))))
	  ;;  Edges data:
	  (setq ent-list (cons (cons 94 (/ (length edges) 2)) ent-list))
	  (foreach vertexindex  edges
		(setq ent-list (cons (cons 90 vertexindex) ent-list)))
	  ;;  Crease data:
	  ;; (setq ent-list (cons (cons 95 (/ (length edges) 2)) ent-list))
	  (setq ent-list (cons (cons 95 0) ent-list))
	  (setq ent-list (append header (reverse ent-list)))

	  ; (print ent-list)
	  (entmake ent-list)
  )

(defun getCastaC_tmpFolder ( / RawKey)
;  (setq RawKey (vl-registry-read "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders" "AppData"))
;  (setq VS_Tmpfolder (strcat RawKey "\\Casta-C\\tmp"))
  (setq AppData_Folder (getenv "APPDATA"))
  (print AppData_Folder)
  (setq VS_Tmpfolder (strcat AppData_Folder "\\Casta-C\\tmp"))
  
)
